package top.cenze.utils;

import cn.hutool.core.util.ObjectUtil;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/**
 * 排序工具
 *
 * @author chengze
 * @date 2023-11-14 22:15
 */
public class SortUtil {

    /**
     * Map按Key的ASCII码排序
     * @param maps
     * @param ignoreNullValue 是否忽略空值key（默认为: true忽略）
     * @return 排序后以&拼接的字符串
     */
    public static String sortMapByKey(Map maps, Boolean ignoreNullValue){
        if (ObjectUtil.isNull(ignoreNullValue)) {
            ignoreNullValue = true;
        }

        //把map的值存储到TreeMap中
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();

        for (Object map : maps.entrySet()){
            Object value = ((Map.Entry) map).getValue();

            // value为空时，忽略
            if (ignoreNullValue && ObjectUtil.isNull(value)) {
                continue;
            }

            // 对数据进行排序
            treeMap.put(((Map.Entry) map).getKey(), value);
        }

        //遍历TreeMap并生成签名data
        Iterator iter = treeMap.keySet().iterator();
        StringBuffer sortData = new StringBuffer();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            String value = (String) treeMap.get(key);
            sortData.append(key);
            sortData.append("=");
            sortData.append(value);
            if (iter.hasNext()) {
                sortData.append("&");
            }
        }

        return String.valueOf(sortData);
    }
}
