package top.cenze.utils.crypt;

import javax.crypto.Cipher;
import java.security.*;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/**
 * RSA对称加密工具
 * （公钥加密，私钥解密）
 * @author chengze
 * @date 2023-11-14 22:05
 */
public class RSAUtil {
    public static int KEY_LENGTH = 1024;//密钥大小
    public static String ALGORITHM_TYPE = "RSA";//算法类型

    /**
     * 生成密钥
     * @return privateKey、publicKey
     * @throws NoSuchAlgorithmException
     */
    public static Map genKeyPair() throws NoSuchAlgorithmException {
        Map<String, String> keyMap = new HashMap<String, String>();//存储公钥和私钥
        //为RSA算法创建KeyPairGenerator对象
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_TYPE);
        //创建RSA算法可信任的随机数源
        SecureRandom secureRandom = new SecureRandom();
        //使用随机数源初始化keyPairGenerator对象
        keyPairGenerator.initialize(KEY_LENGTH, secureRandom);
        //生成密钥对
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        //获取私钥
        PrivateKey privateKey = keyPair.getPrivate();
        //获取公钥
        PublicKey publicKey = keyPair.getPublic();
        //使用base64将私钥和公钥转化为字符串
        String privateKeyStr = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        String publicKeyStr = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        keyMap.put("privateKey", privateKeyStr);
        keyMap.put("publicKey", publicKeyStr);

        return keyMap;
    }

    /**
     * 加密
     * @param data
     * @param publicKey
     * @return
     * @throws Exception
     */
    public static String encrypt(String data, String publicKey) throws Exception {
        //base64编码的公钥解析为二进制
        byte[] publicKeyByte = Base64.getDecoder().decode(publicKey);
        //得到公钥
        PublicKey pubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKeyByte));
        //加密数据
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        //得到加密后的数据
        String encryptData = Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes()));
        return encryptData;
    }

    /**
     * 解密
     * @param data
     * @param privateKey
     * @return
     * @throws Exception
     */
    public static String decrypt(String data, String privateKey) throws Exception {
        //base64编码的私钥解析为二进制
        byte[] privateKeyByte = Base64.getDecoder().decode(privateKey);
        //base64解析后的加密数据
        byte[] dataByte = Base64.getDecoder().decode(data.getBytes());
        //获取私钥
        PrivateKey priKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKeyByte));
        //RSA解密
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(Cipher.DECRYPT_MODE, priKey);
        //得到解密后的数据
        String decryptData = new String(cipher.doFinal(dataByte));
        return decryptData;
    }
}
