package top.cenze.utils.enums;

/**
 * @desc: Excel类型
 * @author: chengze
 * @createByDate: 2023/10/9 9:26
 */
public enum ExcelTypeEnum {
    XLS(".xls", "Microsoft Excel 97-2003版本版本的默认文件格式扩展名"),
    XLSX(".xlsx", "Microsoft Excel 2007及以后版本的默认文件格式扩展名"),
    XLSM(".xlsm", "带有宏的Excel默认文件格式扩展名"),
    ;

    private String extname;
    private String desc;

    ExcelTypeEnum(String _extname, String _desc) {
        this.extname = _extname;
        this.desc = _desc;
    }

    public String getExtname() {
        return extname;
    }

    public String getDesc() {
        return desc;
    }

    public static ExcelTypeEnum getByExtname(String extname) {
        for (ExcelTypeEnum e : ExcelTypeEnum.values()) {
            if (e.getExtname().equals(extname)) {
                return e;
            }
        }

        return null;
    }
}
