package top.cenze.utils.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

/**
 * @desc: excel映射对象
 * @author: chengze
 * @createByDate: 2023/10/11 8:51
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExcelMappingObject {

    //    @ApiModelProperty(value = "行索引值（有效起始值0）")
    private Integer row;

    //    @ApiModelProperty(value = "列索引值（有效起始值0）")
    private Integer col;

    //    @ApiModelProperty(value = "映射对象名（如多级父子对象，则填写：axxx.bxxx）")
    private String objectName;

    //    @ApiModelProperty(value = "映射对象描述")
    private String objectDesc;

    //    @ApiModelProperty(value = "映射对象全类名（xx.xxx.Xxxx）")
    private String objectType;

    //    @ApiModelProperty(value = "映射对象成员名")
    private String objectItemName;

    //    @ApiModelProperty(value = "映射对象成员描述")
    private String objectItemDesc;
}
