package top.cenze.utils;

import cn.hutool.core.util.StrUtil;
import org.apache.commons.codec.binary.Base64;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * base64工具类
 */
public class Base64Util {

    /**
     *  BufferedImage转成 base64
     * @param bufferedImage
     * @param imageFormatName
     * @return
     * @throws IOException
     */
    public static String bufferedImageToBase64(BufferedImage bufferedImage, String imageFormatName) throws IOException {
        if(StrUtil.isBlank(imageFormatName)){
            imageFormatName = "png";
        }

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, imageFormatName, stream);

        String base64 = Base64.encodeBase64String(stream.toByteArray());

        stream.flush();
        stream.close();

        return base64;
    }

    /**
     *  BufferedImage转成 base64 添加base64头
     * @param bufferedImage
     * @param imageFormatName
     * @return
     * @throws IOException
     */
    public static String bufferedImageToBase64AddHead(BufferedImage bufferedImage, String imageFormatName) throws IOException {
        if(StrUtil.isBlank(imageFormatName)){
            imageFormatName = "png";
        }

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, imageFormatName, stream);

        String base64 = Base64.encodeBase64String(stream.toByteArray());

        stream.flush();
        stream.close();

        return "data:image/" + imageFormatName + ";base64," + base64;
    }
}
