package top.cenze.utils.crypt;

import java.security.MessageDigest;

/**
 * MD5摘要算法加密工具
 *
 * @author chengze
 * @date 2023-11-14 22:10
 */
public class MD5Util {
    static char hexDigits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static String MD5 = "MD5";

    /**
     * 加密
     * @param data
     * @param salt
     * @return
     * @throws Exception
     */
    public static String sign(String data, String salt) throws Exception {
        //得到明文的字节数组
        byte[] btInput = (data + salt).getBytes();
        // 创建一个提供信息摘要算法的对象(MD5摘要算法)
        MessageDigest messageDigest = MessageDigest.getInstance(MD5);
        // 使用指定的字节更新摘要
        messageDigest.update(btInput);
        // 得到二进制的密文
        byte[] encryptData = messageDigest.digest();
        // 把密文转换成十六进制的字符串形式
        String encryptDataStr = bytesToHex(encryptData);
        return encryptDataStr;
    }

    /**
     * 验证密码
     * @param data
     * @param salt
     * @param sign
     * @return
     * @throws Exception
     */
    public static boolean verifySign(String data, String salt, String sign) throws Exception {
        //调用加签方法，看加签后的签名是否和收到的一致
        String encryptData = sign(data, salt);
        if (encryptData.equals(sign)){
            return true;
        }else {
            return false;
        }
    }

    //将byte数组转化为十六进制字符串
    public static String bytesToHex(byte[] bytes) {
        int k = 0;
        char[] hexChars = new char[bytes.length * 2];
        for ( int i = 0; i < bytes.length; i++ ) {
            byte byte0 = bytes[i];
            hexChars[k++] = hexDigits[byte0 >>> 4 & 0xf];
            hexChars[k++] = hexDigits[byte0 & 0xf];
        }
        return new String(hexChars);
    }
}
