package top.cenze.utils.enums;

/**
 * @desc: 生成报表文件类型
 * @author: chengze
 * @createByDate: 2023/10/9 9:26
 */
public enum ReportFileTypeEnum {

    PDF(".pdf", "pdf"),
    XLS(".xls", "Excel97 ~ 2003版本"),
    XLSX(".xlsx", "Excel2007及之后版本"),
    HTML(".html", "网页html"),
    ;

    private String extname;
    private String desc;
    ReportFileTypeEnum(String _extName, String _desc) {
        this.extname = _extName;
        this.desc = _desc;
    }

    public String getExtname() {
        return extname;
    }

    public String getDesc() {
        return desc;
    }

    public static ReportFileTypeEnum getByExtName(String extName) {
        for (ReportFileTypeEnum e : ReportFileTypeEnum.values()) {
            if (e.getExtname().equals(extName)) {
                return e;
            }
        }

        return null;
    }
}
