package top.cenze.utils.enums;

/**
 * @desc: 是或否枚举
 * @author: chengze
 * @createByDate: 2023/10/9 9:26
 */
public enum YesOrNoEnum {
    NO(0, "否"),
    YES(1, "是"),
    ;

    private Integer val;
    private String desc;

    YesOrNoEnum(Integer _val, String _desc) {
        this.val = _val;
        this.desc = _desc;
    }

    public Integer getVal() {
        return val;
    }

    public String getDesc() {
        return desc;
    }

    public static YesOrNoEnum getByVal(Integer val) {
        for (YesOrNoEnum e : YesOrNoEnum.values()) {
            if (e.getVal().equals(val)) {
                return e;
            }
        }

        return null;
    }
}
