package top.cenze.utils.file;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import lombok.SneakyThrows;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

import java.io.File;
import java.util.UUID;

public class XMLUtil {
    private static final String EXCEL_TEMPLATE_DIR = "template/";

    // ****************************** 创建 ********************************

    public static Document createDocument() {
        Document doc = XmlUtil.createXml();
        doc.setXmlStandalone(true);
        doc.setXmlVersion("1.0");

        return doc;
    }

    public static Element createElement(Document doc, String name, String data) {
        Text text = doc.createTextNode(name);
        text.setData(data);
        Element element = doc.createElement(name);
        element.appendChild(text);

        return element;
    }

    public static String toXml(Document doc, Element head, Element param, String charset) {
        Element root = doc.createElement("root");
        root.appendChild(head);
        root.appendChild(param);

        doc.appendChild(root);

        if (StrUtil.isEmpty(charset)) {
            charset = "UTF-8";
        }

        if ("GBK".equals(charset)) {
            return XmlUtil.toStr(doc, "GBK", true);
        } else {
            return XmlUtil.toStr(doc);
        }
    }


    // ****************************** 解释 ********************************

    public static Document toXmlDoc(String xmlStr) {
        Document doc = XmlUtil.parseXml(xmlStr);

        return doc;
    }

    public static String getElementValue(Document doc, String name) {
        if (null == doc) {
            return null;
        }
        if (StrUtil.isEmpty(name)) {
            return null;
        }

        return doc.getElementsByTagName(name).item(0)
                .getFirstChild().getNodeValue();
    }

    public static String toStr(Document xml) {
        if (ObjectUtil.isNull(xml)) {
            return null;
        }

        return XmlUtil.toStr(xml);
    }

    @SneakyThrows
    public static byte[] toBytes(Document xml) {
        String str = toStr(xml);
        if (StrUtil.isNotEmpty(str)) {
            str.getBytes("UTF-8");
        }

        return null;
    }

    @SneakyThrows
    public static File toFile(Document xml) {
        if (ObjectUtil.isNull(xml)) {
            return null;
        }

        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".xml";
        File tmpFile = CZFileUtil.mkFileToResource(EXCEL_TEMPLATE_DIR, templateFileName);
        XmlUtil.toFile(xml, tmpFile.getPath());

//        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".xml";
//        File tmpFile = CZFileUtil.mkFileToResource(EXCEL_TEMPLATE_DIR, templateFileName);
//        if (!FileUtil.exist(tmpFile)) {
//            throw new NullPointerException("创建文件失败");
//        }
//
//        FileOutputStream fos = new FileOutputStream(tmpFile);
//        //设置格式
//        OutputFormat format = new OutputFormat();
//        format.setIndentSize(4); //缩进为4
//        format.setNewlines(true);   //换行
//        format.setTrimText(true);   //去除空格
//        format.setEncoding("UTF-8");
//        XMLWriter xw = new XMLWriter(fos, format);
//        //将整个文档对象写入到文件中
//        xw.write(xml);
//        xw.close();
//        fos.flush();
//        fos.close();

        return tmpFile;
    }
}
