package top.cenze.utils.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @desc: 类属性（字段）信息
 * @author: chengze
 * @createByDate: 2023/10/30 9:38
 */
@ApiModel(value = "类属性（字段）")
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassFieldInfo {

    @ApiModelProperty("字段名称")
    private String name;

    @ApiModelProperty("字段类型")
    private String type;

    @ApiModelProperty("字段描述（Swagger ApiModelProperty value值）")
    private String desc;

    @ApiModelProperty("是否为接口类或父类继承的字段")
    private Boolean isParent = false;
}
