package top.cenze.utils.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @desc: excel字段信息
 * @author: chengze
 * @createByDate: 2023/11/21 11:25
 */
@ApiModel(value = "excel字段信息")
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExcelFieldInfo {
    @ApiModelProperty(value = "字段名")
    private String fieldName;

    @ApiModelProperty(value = "单元格")
    private String cell;

    @ApiModelProperty(value = "行索引")
    private Integer rowIdx;

    @ApiModelProperty(value = "列索引")
    private Integer colIdx;
}
