package top.cenze.utils;

import org.jasypt.util.text.BasicTextEncryptor;

/**
 * 配置文件加密解密工具
 */
public class JasyptUtil {
    private final static BasicTextEncryptor encryptor = new BasicTextEncryptor();

    /**
     * 加密
     * @param s             待加密字符串
     * @param secretKey     密钥
     * @return
     */
    public static String encrypt(String s, String secretKey) {
        encryptor.setPassword(secretKey);
        return encryptor.encrypt(s);
    }

    /**
     * 解密
     * @param s             待加密字符串
     * @param secretKey     密钥
     * @return
     */
    public static String decrypt(String s, String secretKey) {
        encryptor.setPassword(secretKey);
        return encryptor.decrypt(s);
    }

//    public static void main(String[] args) {
//        // Olmysoft*123
//        // root
//        // nacos
//        String encrypt = JasyptUtil.encrypt("root", "Otms-Ltl");
//        System.out.println(encrypt);
//    }
}
