package top.cenze.utils;

import cn.hutool.core.util.StrUtil;
import com.jcraft.jsch.*;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Properties;
import java.util.Vector;

/**
 * 文件传输工具
 *
 * @author chengze
 * @date 2023-11-14 22:27
 */
public class SFTPUtil {

    protected final static int CLIENT_TIMEOUT = 1000 * 180;

    public SFTPUtil(){

    }
    /**
     * 连接Sftp服务器
     */
    public static ChannelSftp login(String host, int port, String username, String password) {
        Session session = null;
        ChannelSftp Sftp = null;
        try {
            JSch jSch = new JSch();
            session = jSch.getSession(username, host, port);
            session.setTimeout(CLIENT_TIMEOUT);
            if (StrUtil.isNotEmpty(password)) {
                session.setPassword(Base64.getDecoder().decode(password));
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            Channel channel = session.openChannel("Sftp");
            channel.connect();
            Sftp = (ChannelSftp) channel;
        } catch (JSchException e) {
        }
        return Sftp;
    }
    /**
     * 关闭连接 server
     */
    public static void logout(ChannelSftp Sftp){
        if (Sftp != null) {
            Session session = null;
            try {
                session = Sftp.getSession();
                if (Sftp.isConnected()) {
                    Sftp.disconnect();
                }
            } catch (JSchException e) {
            } finally {
                if (session != null) {
                    session.disconnect();
                }
            }
        }
    }

    /**
     * 将输入流的数据上传到Sftp作为文件。文件完整路径=basePath+directory
     * @param basePath  服务器的基础路径
     * @param SftpFileName  Sftp端文件名
     */
    public static boolean upload(String host, int port, String username, String password, String basePath, String SftpFileName, InputStream input) {
        boolean success = true;
        ChannelSftp Sftp = login(host, port, username, password);
        try {
            Sftp.cd(basePath);
        } catch (SftpException e) {
            //目录不存在，则创建文件夹
            String [] dirs = basePath.split("/");
            String tempPath = "";
            for(String dir:dirs){
                if(null== dir || "".equals(dir)) {
                    continue;
                }
                tempPath+="/"+dir;
                try {
                    Sftp.cd(tempPath);
                } catch (SftpException O1) {
                    try {
                        Sftp.mkdir(tempPath);
                        Sftp.cd(tempPath);
                    } catch (SftpException e2) {
                    }
                }
                try{
                    Sftp.cd(tempPath);
                }catch(SftpException O1){
                }
            }
        }
        try {
            //上传文件
            Sftp.put(input, SftpFileName);
        } catch (SftpException e) {
            // TODO Auto-generated catch block
            success = false;
        } finally {
            logout(Sftp);
        }
        return success;
    }

    /**
     * 下载文件。
     */
    public static boolean download(String host, int port, String username, String password, String filePath, final OutputStream outputStream) {
        boolean downloaded = true;
        ChannelSftp Sftp = login(host, port, username, password);
        String fileName = null;
        try {
            if (filePath != null && !"".equals(filePath)) {
                String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
                Sftp.cd(directory);
            }
            fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);

            Sftp.get(fileName, outputStream);
        } catch (SftpException e) {
            downloaded = false;
        } finally {
            logout(Sftp);
        }
        return downloaded;
    }

    /**
     * 删除文件
     */
    public static boolean delete(String host, int port, String username, String password, String filePath){
        boolean success = true;
        ChannelSftp Sftp = null;
        try {
            Sftp = login(host, port, username, password);
            String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
            Sftp.cd(directory);
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            Sftp.rm(fileName);
        } catch (SftpException e) {
            success = false;
        } finally {
            logout(Sftp);
        }
        return success;
    }

    /**
     * 列出目录下的文件
     */
    public static boolean isFileExist(String host, int port, String username, String password, String filePath) {
        boolean success = false;
        ChannelSftp Sftp = null;
        try {
            Sftp = login(host, port, username, password);
            String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            Vector<?> vector = Sftp.ls(directory);
            for (Object obj : vector) {
                if (obj != null) {
                    ChannelSftp.LsEntry lsEntry = (ChannelSftp.LsEntry) obj;
                    if (fileName.equals(lsEntry.getFilename())) {
                        success = true;
                        break;
                    }
                }
            }
        } catch (Exception e) {
        } finally {
            logout(Sftp);
        }
        return success;
    }
}
