package top.cenze.utils;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.codec.binary.Base64;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

/**
 * base64工具类
 */
public class Base64Util {

    /**
     *  BufferedImage转成 base64
     * @param bufferedImage
     * @param imageFormatName
     * @return
     * @throws IOException
     */
    public static String bufferedImageToBase64(BufferedImage bufferedImage, String imageFormatName) throws IOException {
        if(StrUtil.isBlank(imageFormatName)){
            imageFormatName = "png";
        }

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, imageFormatName, stream);

        String base64 = Base64.encodeBase64String(stream.toByteArray());

        stream.flush();
        stream.close();

        return base64;
    }

    /**
     *  BufferedImage转成 base64 添加base64头
     * @param bufferedImage
     * @param imageFormatName
     * @return
     * @throws IOException
     */
    public static String bufferedImageToBase64AddHead(BufferedImage bufferedImage, String imageFormatName) throws IOException {
        if(StrUtil.isBlank(imageFormatName)){
            imageFormatName = "png";
        }

        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, imageFormatName, stream);

        String base64 = Base64.encodeBase64String(stream.toByteArray());

        stream.flush();
        stream.close();

        return "data:image/" + imageFormatName + ";base64," + base64;
    }

    /**
     * https://blog.51cto.com/u_16213386/8649945
     * https://blog.51cto.com/u_16175504/6931837
     * @param data
     * @return
     */
    public static String urlEncode(Object data) throws UnsupportedEncodingException {
        return urlEncode(JSON.toJSONString(data));
    }
    public static String urlEncode(String data) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64URLSafe(data.getBytes()));
    }

    public static String urlDecode(String data) {
        return new String(Base64.decodeBase64(data));
    }
}
