package top.cenze.utils.enums;

/**
 * @desc: Excel映射类型
 * @author: chengze
 * @createByDate: 2023/10/9 9:26
 */
public enum MappingTypeEnum {
    CUSTOM(0, "自定义（直接填充内容）"),
    OBJECT(1, "对象（直接对象属性或方法取值）"),
    LOOP(2, "循环（遍历对象属性或方法取值）"),
    ;

    private Integer val;
    private String desc;

    MappingTypeEnum(Integer _val, String _desc) {
        this.val = _val;
        this.desc = _desc;
    }

    public Integer getVal() {
        return val;
    }

    public String getDesc() {
        return desc;
    }

    public static MappingTypeEnum getByVal(Integer val) {
        for (MappingTypeEnum e : MappingTypeEnum.values()) {
            if (e.getVal().equals(val)) {
                return e;
            }
        }

        return null;
    }
}
