package top.cenze.utils.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @desc: 接口鉴权配置
 * @author: chengze
 * @createByDate: 2023/12/31 20:29
 */
@ApiModel(value = "接口鉴权配置")
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ApiAuthConfig {
    @ApiModelProperty(value = "开放接口uri")
    private String apiUri;

    @ApiModelProperty(value = "开放接口请求次数（限制时间范围内）")
    private Integer accessCount;

    @ApiModelProperty(value = "开放接口第一次请求时间戳（限制时间范围内，单位：分钟）")
    private Integer accessFirstTime;

    @ApiModelProperty(value = "开放接口（0否，1是）")
    private Integer isOpen;

    @ApiModelProperty(value = "需要鉴权（0否，1是）")
    private Integer requireAuth;

    @ApiModelProperty(value = "限制访问次数（0~65535），0不限制")
    private Integer limitCount;

    @ApiModelProperty(value = "限制时间戳范围（0~ 4294967295，单位：分钟），0不限制（多少分钟内限制访问多少次，limit_count或limit_time为0时，不限制）")
    private Integer limitTime;
}
