package top.cenze.utils.http.response;

import cn.hutool.core.util.ObjectUtil;
import lombok.SneakyThrows;
import org.springframework.http.MediaType;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;

/**
 * @desc: 请求结果工具
 * @author: chengze
 * @createByDate: 2024/1/8 14:08
 */
public class ResponseUtil {

    /**
     * 转文件流
     * @param multipartFile
     * @param response
     */
    @SneakyThrows
    public void toStream(MultipartFile multipartFile, HttpServletResponse response) {
        if (ObjectUtil.isNull(multipartFile) || "".equals(multipartFile) || multipartFile.getSize() <= 0) {
            throw new Exception("导出文件异常");
        }

        // response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);

        ServletOutputStream outputStream = response.getOutputStream();
        byte[] buf = new byte[4096];
        int bytesRead;
        InputStream inputStream = multipartFile.getInputStream();
        while ((bytesRead = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, bytesRead);
        }

        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }
}
