package top.cenze.utils;

import cn.hutool.core.util.ObjectUtil;

import java.util.Calendar;
import java.util.Date;

/**
 * @desc: 日期转换
 * https://blog.csdn.net/chengxuyuan_110/article/details/81183922
 * @author: chengze
 * @createByDate: 2023/11/14 11:07
 */
public class DateUtil extends cn.hutool.core.date.DateUtil {

    /**
     * get first date of given month and year
     * @param year
     * @param month
     * @return
     */
    public static String getFirstDayOfMonth(int year, int month){
        String monthStr = month < 10 ? "0" + month : String.valueOf(month);
        return year + "-"+monthStr+"-" +"01";
    }

    /**
     * get the last date of given month and year
     * @param year
     * @param month
     * @return
     */
    public static String getLastDayOfMonth(int year, int month){
        Calendar calendar = Calendar.getInstance();
        calendar.set(Calendar.YEAR , year);
        calendar.set(Calendar.MONTH , month - 1);
        calendar.set(Calendar.DATE , 1);
        calendar.add(Calendar.MONTH, 1);
        calendar.add(Calendar.DAY_OF_YEAR , -1);
        return calendar.get(Calendar.YEAR) + "-" + (calendar.get(Calendar.MONTH) + 1) + "-" +
                calendar.get(Calendar.DAY_OF_MONTH);
    }

    /**
     * get Calendar of given year
     * @param year
     * @return
     */
    public static Calendar getCalendarFormYear(int year){
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
        cal.set(Calendar.YEAR, year);
        return cal;
    }

    /**
     * 获取指定年份（如：2023），指定周号（如果：第30周）起始日期
     * get start date of given week no of a year
     * @param year
     * @param weekNo
     * @return      yyyy-MM-dd
     */
    public static String getStartDayOfWeekNo(int year, int weekNo){
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);

    }

    /**
     * 获取指定年份（如：2023），指定周号（如果：第30周）截止日期
     * get the end day of given week no of a year.
     * @param year
     * @param weekNo
     * @return      yyyy-MM-dd
     */
    public static String getEndDayOfWeekNo(int year, int weekNo){
        Calendar cal = getCalendarFormYear(year);
        cal.set(Calendar.WEEK_OF_YEAR, weekNo);
        cal.add(Calendar.DAY_OF_WEEK, 6);
        return cal.get(Calendar.YEAR) + "-" + (cal.get(Calendar.MONTH) + 1) + "-" +
                cal.get(Calendar.DAY_OF_MONTH);
    }

    public static Date calendar2Date(Calendar calendar) {
        if (ObjectUtil.isNull(calendar)) {
            return null;
        }

        return calendar.getTime();
    }

    public static Calendar date2Calendar(Date date) {
        if (ObjectUtil.isNull(date)) {
            return null;
        }

        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);

        return calendar;
    }
}
