package top.cenze.utils.aop;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @desc: 接口鉴权Aop
 * @author: chengze
 * @createByDate: 2023/12/29 11:18
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface ApiAuth {

    // 是否开启鉴权校验，默认开启
    boolean chkAuth() default true;

    // 是否开启访问次数限制校验，默认关闭
    boolean chkLimit() default false;
}
