package top.cenze.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @desc: 集合工具
 * @author: chengze
 * @createByDate: 2024/1/12 9:21
 */
@Slf4j
public class CollectionUtil {

    /**
     * 查一个字符串集合内的字符串是否包含某一个str（忽略字符串中的大小写）
     * @param str
     * @param lstStr
     * @return      返回集合中第一个包含此str的字符串
     */
    public static String containsStrIgnoreCase(String str, List<String> lstStr) {
        if (cn.hutool.core.collection.CollectionUtil.isEmpty(lstStr)) {
            return null;
        }

        // lsit 转 set
        Set<String> setkeys = lstStr.stream().collect(Collectors.toSet());
        log.info("containsStrIgnoreCase keys: {}", JSON.toJSONString(setkeys));

        // 接口关键字集合为空时，则赋一个空值
        String[] keys = null;
        if (cn.hutool.core.collection.CollectionUtil.isEmpty(setkeys)) {
            setkeys = new HashSet<>();
            setkeys.add("");
            keys = new String[] {""};
        } else {
            keys = Convert.toStrArray(setkeys);
        }

        // 查一个字符串集合内的字符串是否包含某一个str，返回集合中第一个包含此str的字符串
        return StrUtil.getContainsStrIgnoreCase(str, keys);
    }

    /**
     * List集合切割成几份
     * https://blog.csdn.net/qq_43532275/article/details/123786761
     * @param lstObject
     * @param parts         几份，如果为空（默认1份）
     * @param <T>
     * @return              返回map的key从0开始
     */
    public static <T> Map<Integer, List<T>> slice(List<T> lstObject , Integer parts) {
        if (ObjectUtil.isNull(parts)) {
            parts = 1;
        }

        // 切割后的map
        Map<Integer, List<T>> mapSlice = new HashMap<>();

        // 如果只分1份，直接返回
        if (parts.equals(1)) {
            mapSlice.put(0, lstObject);
            return mapSlice;
        }

        int groupCount = lstObject.size() / parts;   // 计算商
        int residue = lstObject.size() % parts;      // 计算余数
        log.info("slice groupCount: {}, residue: {}", groupCount, residue);

        for (int i = 0; i < parts; i++) {
            // 把数据拆成N小组
            int startIndex = i * groupCount;
            int endIndex = startIndex + groupCount;
            if (i == parts - 1) {
                endIndex = endIndex + residue;
            }
            if (endIndex > lstObject.size()) {
                endIndex = lstObject.size();
            }
            log.info("slice startIndex: {}, endIndex: {}", startIndex, endIndex);
            List<T> sublist = lstObject.subList(startIndex, endIndex);

            if (cn.hutool.core.collection.CollectionUtil.isNotEmpty(sublist)) {
                mapSlice.put(i, sublist);
            }
        }

        return mapSlice;
    }
}
