package top.cenze.utils.aspect;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.cenze.utils.aop.ApiAuth;
import top.cenze.utils.plugins.ApiPlugin;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

/**
 * @desc: 接口鉴权切面
 * @author: chengze
 * @createByDate: 2023/12/29 11:21
 */
@Slf4j
public abstract class ApiAuthAspect extends ApiPlugin {
    @Pointcut("@annotation(top.cenze.utils.aop.ApiAuth)")
    public void authPointcut() {}

    @Before("authPointcut()")
    public void authBefore(JoinPoint joinPoint) throws Exception {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ApiAuth apiAuth = method.getAnnotation(ApiAuth.class);
        if (ObjectUtil.isNull(apiAuth)) {
            return;
        }
        log.info("authBefore apiAuth: {}", JSON.toJSONString(apiAuth));

        ServletRequestAttributes requestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        // 此处无需判断 requestAttributes 是否为空
        HttpServletRequest request = requestAttributes.getRequest();
        // 获取请求头中的 Authorization 信息
//        String authorization = request.getHeader("Authorization");

        // 当前请求鉴权是否通过
        if (apiAuth.chkAuth() && !auth(request, true)) {
            throw new Exception("未鉴权的访问");
        }

        // 当前请求访问次数超限制
        if (apiAuth.chkLimit() && exceedLimitCount(request)) {
            throw new Exception("超过请求次数，请稍后再试");
        }
    }
}
