package top.cenze.utils.crypt;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import top.cenze.utils.ConvertUtil;
import top.cenze.utils.crypt.sm.sm2.Cipher;
import top.cenze.utils.crypt.sm.sm2.SM2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/**
 * SM2国密加密解密工具
 *
 * @author chengze
 * @date 2023-11-14 22:35
 */
public class SM2Util {

    //生成随机秘钥对
    public static Map generateKeyPair() {
        Map<String, String> keyMap = new HashMap<String, String>(); // 存储公钥和私钥
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters) key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters) key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        publicKey.getEncoded(true);
        keyMap.put("privateKey", ConvertUtil.byteToHex(privateKey.toByteArray()));
        keyMap.put("publicKey", ConvertUtil.byteToHex(publicKey.getEncoded(true)));
//        System.out.println("公钥: " + ConvertUtil.byteToHex(publicKey.getEncoded()));
//        System.out.println("私钥: " + ConvertUtil.byteToHex(privateKey.toByteArray()));

        return keyMap;
    }

    //数据加密
    public static String encrypt(byte[] publicKey, byte[] data) throws IOException
    {
        if (publicKey == null || publicKey.length == 0)
        {
            return null;
        }

        if (data == null || data.length == 0)
        {
            return null;
        }

        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);

        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);

        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);

//      System.out.println("C1 " + Utils.byteToHex(c1.getEncoded()));
//      System.out.println("C2 " + Utils.byteToHex(source));
//      System.out.println("C3 " + Utils.byteToHex(c3));
        //C1 C2 C3拼装成加密字串
        return ConvertUtil.byteToHex(c1.getEncoded()) + ConvertUtil.byteToHex(source) + ConvertUtil.byteToHex(c3);

    }

    //数据解密
    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException
    {
        if (privateKey == null || privateKey.length == 0)
        {
            return null;
        }

        if (encryptedData == null || encryptedData.length == 0)
        {
            return null;
        }
        //加密字节数组转换为十六进制的字符串 长度变为encryptedData.length * 2
        String data = ConvertUtil.byteToHex(encryptedData);
        /***分解加密字串
         * （C1 = C1标志位2位 + C1实体部分128位 = 130）
         * （C3 = C3实体部分64位  = 64）
         * （C2 = encryptedData.length * 2 - C1长度  - C2长度）
         */
        byte[] c1Bytes = ConvertUtil.hexToByte(data.substring(0,130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = ConvertUtil.hexToByte(data.substring(130,130 + 2 * c2Len));
        byte[] c3 = ConvertUtil.hexToByte(data.substring(130 + 2 * c2Len,194 + 2 * c2Len));

        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);

        //通过C1实体字节来生成ECPoint
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);

        //返回解密结果
        return c2;
    }


    //数据加密
    public static String encrypt(String publicKeyStr, String dataStr) throws IOException
    {
        byte[] publicKey = ConvertUtil.hexToByte(publicKeyStr);
        byte[] data = dataStr.getBytes("UTF-8");

        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);

        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);

        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);

        //C1 C2 C3拼装成加密字串
        return ConvertUtil.byteToHex(c1.getEncoded()) + ConvertUtil.byteToHex(source) + ConvertUtil.byteToHex(c3);

    }

    //数据解密
    public static byte[] decrypt(String privateKeyStr, String encryptedDataStr) throws IOException
    {
        byte[] privateKey = ConvertUtil.hexToByte(privateKeyStr);
        byte[] encryptedData = ConvertUtil.hexToByte(encryptedDataStr);
        //加密字节数组转换为十六进制的字符串 长度变为encryptedData.length * 2
        String data = ConvertUtil.byteToHex(encryptedData);
        /***分解加密字串
         * （C1 = C1标志位2位 + C1实体部分128位 = 130）
         * （C3 = C3实体部分64位  = 64）
         * （C2 = encryptedData.length * 2 - C1长度  - C2长度）
         */
        byte[] c1Bytes = ConvertUtil.hexToByte(data.substring(0,130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = ConvertUtil.hexToByte(data.substring(130,130 + 2 * c2Len));
        byte[] c3 = ConvertUtil.hexToByte(data.substring(130 + 2 * c2Len,194 + 2 * c2Len));

        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);

        //通过C1实体字节来生成ECPoint
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);

        //返回解密结果
        return c2;
    }

//    public static void main(String[] args){
//        generateKeyPair();
//        String publicKey = "04CF0565941EAE46B935057343EC7CD51F6BB4DCEC10238667625ECE3BD516F2323C781B0A5B97C123748353ACA81221C974C662A2C1C320F7532DDD2D3ECC106F";
//        String privateKey = "00AA40384C9AB7CC44E8B2481737F98C88A8C8474497DA0CFE58B625BB3E79F97B";
//        String ss = "oahgiooahgiouaoi弄我阿济格hi噢阿济格hi噢hi";
//
//        try {
//            String dataEn = encrypt(publicKey, ss);
//            System.out.println(dataEn);
//
//            String dataDe = new String(decrypt(privateKey,dataEn));
//            System.out.println(dataDe);
//        }catch (Exception e){
//            e.printStackTrace();
//        }
//    }
}
