/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AsciiUtil {
    public static TreeMap<String, Object> sortByAsc(Object obj) {
        return AsciiUtil.sortByAsc(obj, true);
    }

    public static TreeMap<String, Object> sortByAsc(Object obj, boolean excludeNullField) {
        if (ObjectUtil.isNull((Object)obj)) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                Object value = field.get(obj);
                if (excludeNullField && ObjectUtil.isNotNull((Object)value)) {
                    sortedMap.put(field.getName(), value);
                    continue;
                }
                sortedMap.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return sortedMap;
    }

    public static TreeMap<String, Object> sortByAsc(JSONObject jsonObj) {
        return AsciiUtil.sortByAsc(jsonObj, true);
    }

    public static TreeMap<String, Object> sortByAsc(JSONObject jsonObj, boolean excludeNullField) {
        if (ObjectUtil.isNull((Object)jsonObj)) {
            return null;
        }
        Set keys = jsonObj.keySet();
        if (CollectionUtil.isEmpty((Collection)keys)) {
            return null;
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        for (String key : keys) {
            Object value = jsonObj.get((Object)key);
            if (excludeNullField && ObjectUtil.isNotNull((Object)value)) {
                sortedMap.put(key, value);
                continue;
            }
            sortedMap.put(key, value);
        }
        return sortedMap;
    }

    public static TreeMap<String, Object> sortByAsc(Map<String, Object> mapObj) {
        return AsciiUtil.sortByAsc(mapObj, true);
    }

    public static TreeMap<String, Object> sortByAsc(Map<String, Object> mapObj, boolean excludeNullField) {
        if (CollectionUtil.isEmpty(mapObj)) {
            return null;
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        for (Map.Entry<String, Object> entry : mapObj.entrySet()) {
            if (excludeNullField && ObjectUtil.isNotNull((Object)entry.getValue())) {
                sortedMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static String treeMap2UrlStr(TreeMap<String, Object> treeMap) {
        return AsciiUtil.treeMap2UrlStr(treeMap, "&");
    }

    public static String treeMap2UrlStr(TreeMap<String, Object> treeMap, String separator) {
        if (CollectionUtil.isEmpty(treeMap)) {
            return null;
        }
        if (StrUtil.isEmpty((CharSequence)separator)) {
            separator = "&";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : treeMap.keySet()) {
            sb.append(key).append("=").append(treeMap.get(key)).append(separator);
        }
        String str = sb.toString();
        if (StrUtil.isNotEmpty((CharSequence)str)) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsciiUtil)) {
            return false;
        }
        AsciiUtil other = (AsciiUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsciiUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "AsciiUtil()";
    }
}

