/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.util.StrUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class BarCodeUtil {
    private static final int WIDTH = 390;
    private static final int HEIGHT = 50;
    private static final int WORDHEIGHT = 75;
    private static Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(EncodeHintType.CHARACTER_SET, "utf-8");
        }
    };

    public static BufferedImage getBarCode(String vaNumber) {
        return BarCodeUtil.getBarCode(vaNumber, 390, 50);
    }

    public static BufferedImage getBarCode(String vaNumber, int width, int height) {
        try {
            Code128Writer writer = new Code128Writer();
            if (0 == width) {
                width = writer.encode(vaNumber).length;
            }
            if (0 == height) {
                height = 50;
            }
            int codeMultiples = 1;
            int codeWidth = width * codeMultiples;
            BitMatrix bitMatrix = new MultiFormatWriter().encode(vaNumber, BarcodeFormat.CODE_128, codeWidth, height, hints);
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage insertWords(BufferedImage image, String words) {
        if (StrUtil.isEmpty((CharSequence)words)) {
            return null;
        }
        BufferedImage outImage = new BufferedImage(390, 75, 1);
        Graphics2D g2d = outImage.createGraphics();
        BarCodeUtil.setGraphics2D(g2d);
        BarCodeUtil.setColorWhite(g2d);
        g2d.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        Color color = new Color(0, 0, 0);
        g2d.setColor(color);
        g2d.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
        int strWidth = g2d.getFontMetrics().stringWidth(words);
        int wordStartX = (390 - strWidth) / 2;
        int wordStartY = 70;
        g2d.drawString(words, wordStartX, wordStartY);
        g2d.dispose();
        outImage.flush();
        return outImage;
    }

    private static void setGraphics2D(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(s);
    }

    private static void setColorWhite(Graphics2D g2d) {
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, 600, 600);
        g2d.setColor(Color.BLACK);
    }
}

