/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtil.class);

    public static String containsStrIgnoreCase(String str, List<String> lstStr) {
        if (cn.hutool.core.collection.CollectionUtil.isEmpty(lstStr)) {
            return null;
        }
        Set setkeys = lstStr.stream().collect(Collectors.toSet());
        log.info("containsStrIgnoreCase keys: {}", (Object)JSON.toJSONString(setkeys));
        CharSequence[] keys = null;
        if (cn.hutool.core.collection.CollectionUtil.isEmpty(setkeys)) {
            setkeys = new HashSet();
            setkeys.add("");
            keys = new String[]{""};
        } else {
            keys = Convert.toStrArray(setkeys);
        }
        return StrUtil.getContainsStrIgnoreCase((CharSequence)str, (CharSequence[])keys);
    }

    public static <T> Map<Integer, List<T>> slice(List<T> lstObject, Integer parts) {
        if (ObjectUtil.isNull((Object)parts)) {
            parts = 1;
        }
        HashMap<Integer, List<T>> mapSlice = new HashMap<Integer, List<T>>();
        if (parts.equals(1)) {
            mapSlice.put(0, lstObject);
            return mapSlice;
        }
        int groupCount = lstObject.size() / parts;
        int residue = lstObject.size() % parts;
        log.info("slice groupCount: {}, residue: {}", (Object)groupCount, (Object)residue);
        for (int i = 0; i < parts; ++i) {
            int startIndex = i * groupCount;
            int endIndex = startIndex + groupCount;
            if (i == parts - 1) {
                endIndex += residue;
            }
            if (endIndex > lstObject.size()) {
                endIndex = lstObject.size();
            }
            log.info("slice startIndex: {}, endIndex: {}", (Object)startIndex, (Object)endIndex);
            List<T> sublist = lstObject.subList(startIndex, endIndex);
            if (!cn.hutool.core.collection.CollectionUtil.isNotEmpty(sublist)) continue;
            mapSlice.put(i, sublist);
        }
        return mapSlice;
    }
}

