/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import com.spire.xls.Workbook;
import com.spire.xls.Worksheet;
import com.spire.xls.core.spreadsheet.HTMLOptions;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import top.cenze.utils.file.CZFileUtil;
import top.cenze.utils.file.MultipartFileUtil;

public class ExcelConvertUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelConvertUtil.class);

    public static MultipartFile toPdf(MultipartFile excelFile) {
        return ExcelConvertUtil.toPdf(excelFile, 0, true, true);
    }

    public static MultipartFile toPdf(MultipartFile excelFile, Boolean fitToPage) {
        return ExcelConvertUtil.toPdf(excelFile, 0, fitToPage, true);
    }

    public static MultipartFile toPdf(MultipartFile excelFile, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        File inFile = CZFileUtil.loadFile(excelFile);
        log.info("toPdf in file name: {}, length: {}, path: {}", new Object[]{inFile.getName(), inFile.length(), inFile.getPath()});
        if (ObjectUtil.isNull((Object)inFile)) {
            return null;
        }
        MultipartFile tmpFile = null;
        File outFile = CZFileUtil.createPdfFile();
        log.info("toPdf out file1 name: {}, length: {}, path: {}", new Object[]{outFile.getName(), outFile.length(), outFile.getPath()});
        ExcelConvertUtil.toPdf(inFile.getPath(), outFile.getPath(), sheetNum, fitToPage, autoFitColumn);
        outFile = CZFileUtil.loadFile(outFile.getPath());
        log.info("toPdf out file2 name: {}, length: {}, path: {}", new Object[]{outFile.getName(), outFile.length(), outFile.getPath()});
        if (ObjectUtil.isNotNull((Object)outFile) && FileUtil.exist((File)outFile)) {
            tmpFile = MultipartFileUtil.getMultipartFile(outFile);
        }
        FileUtil.del((File)inFile);
        FileUtil.del((File)outFile);
        log.info("toPdf multi file name: {}, size: {}", (Object)tmpFile.getOriginalFilename(), (Object)tmpFile.getSize());
        return tmpFile;
    }

    public static void toPdf(String inputFilePath, String outputFilePath, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        if (ObjectUtil.isNull((Object)sheetNum)) {
            sheetNum = 0;
        }
        Workbook wb = new Workbook();
        wb.loadFromFile(inputFilePath);
        Worksheet sheet = wb.getWorksheets().get(sheetNum.intValue());
        if (ObjectUtil.isNotNull((Object)fitToPage) && fitToPage.booleanValue()) {
            wb.getConverterSetting().setSheetFitToPage(true);
        }
        if (ObjectUtil.isNotNull((Object)autoFitColumn) && autoFitColumn.booleanValue()) {
            for (int i = 1; i < sheet.getColumns().length; ++i) {
                sheet.autoFitColumn(i);
            }
        }
        sheet.saveToPdf(outputFilePath);
    }

    public static MultipartFile toPng(MultipartFile excelFile) {
        return ExcelConvertUtil.toPng(excelFile, 0, true, true);
    }

    public static MultipartFile toPng(MultipartFile excelFile, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        File inFile = CZFileUtil.loadFile(excelFile);
        if (ObjectUtil.isNull((Object)inFile)) {
            return null;
        }
        MultipartFile tmpFile = null;
        File outFile = CZFileUtil.createPngFile();
        ExcelConvertUtil.toPng(inFile.getPath(), outFile.getPath(), sheetNum, fitToPage, autoFitColumn);
        outFile = CZFileUtil.loadFile(outFile.getPath());
        if (ObjectUtil.isNotNull((Object)outFile) && FileUtil.exist((File)outFile)) {
            tmpFile = MultipartFileUtil.getMultipartFile(outFile);
        }
        FileUtil.del((File)inFile);
        FileUtil.del((File)outFile);
        return tmpFile;
    }

    public static void toPng(String inputFilePath, String outputFilePath, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        if (ObjectUtil.isNull((Object)sheetNum)) {
            sheetNum = 0;
        }
        Workbook wb = new Workbook();
        wb.loadFromFile(inputFilePath);
        Worksheet sheet = wb.getWorksheets().get(sheetNum.intValue());
        if (ObjectUtil.isNotNull((Object)fitToPage) && fitToPage.booleanValue()) {
            wb.getConverterSetting().setSheetFitToPage(true);
        }
        if (ObjectUtil.isNotNull((Object)autoFitColumn) && autoFitColumn.booleanValue()) {
            for (int i = 1; i < sheet.getColumns().length; ++i) {
                sheet.autoFitColumn(i);
            }
        }
        sheet.saveToImage(outputFilePath);
    }

    public static MultipartFile toHtml(MultipartFile excelFile) {
        return ExcelConvertUtil.toHtml(excelFile, 0, true, true);
    }

    public static MultipartFile toHtml(MultipartFile excelFile, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        File inFile = CZFileUtil.loadFile(excelFile);
        if (ObjectUtil.isNull((Object)inFile)) {
            return null;
        }
        MultipartFile tmpFile = null;
        File outFile = CZFileUtil.createHtmlFile();
        ExcelConvertUtil.toHtml(inFile.getPath(), outFile.getPath(), sheetNum, fitToPage, autoFitColumn);
        outFile = CZFileUtil.loadFile(outFile.getPath());
        if (ObjectUtil.isNotNull((Object)outFile) && FileUtil.exist((File)outFile)) {
            tmpFile = MultipartFileUtil.getMultipartFile(outFile);
        }
        return tmpFile;
    }

    public static void toHtml(String inputFilePath, String outputFilePath, Integer sheetNum, Boolean fitToPage, Boolean autoFitColumn) {
        if (ObjectUtil.isNull((Object)sheetNum)) {
            sheetNum = 0;
        }
        Workbook wb = new Workbook();
        wb.loadFromFile(inputFilePath);
        Worksheet sheet = wb.getWorksheets().get(sheetNum.intValue());
        if (ObjectUtil.isNotNull((Object)fitToPage) && fitToPage.booleanValue()) {
            wb.getConverterSetting().setSheetFitToPage(true);
        }
        if (ObjectUtil.isNotNull((Object)autoFitColumn) && autoFitColumn.booleanValue()) {
            for (int i = 1; i < sheet.getColumns().length; ++i) {
                sheet.autoFitColumn(i);
            }
        }
        HTMLOptions options = new HTMLOptions();
        options.setImageEmbedded(true);
        sheet.saveToHtml(outputFilePath, options);
    }

    public static void office2PDF(String inputFilePath, String outputFilePath) {
    }
}

