/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.lang.NullArgumentException;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jxls.common.Context;
import org.jxls.expression.JexlExpressionEvaluator;
import org.jxls.reader.ReaderBuilder;
import org.jxls.reader.ReaderConfig;
import org.jxls.reader.XLSReadStatus;
import org.jxls.reader.XLSReader;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiTransformer;
import org.jxls.transform.poi.WritableCellValue;
import org.jxls.transform.poi.WritableHyperlink;
import org.jxls.util.JxlsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import top.cenze.utils.ConvertUtil;
import top.cenze.utils.component.ExcelDateConverter;
import top.cenze.utils.enums.ExcelTypeEnum;
import top.cenze.utils.file.CZFileUtil;
import top.cenze.utils.file.MultipartFileUtil;
import top.cenze.utils.file.XMLUtil;
import top.cenze.utils.pojo.ExcelFieldInfo;
import top.cenze.utils.pojo.ExcelMapping;
import top.cenze.utils.pojo.ExcelMappingCustom;
import top.cenze.utils.pojo.ExcelMappingLoop;
import top.cenze.utils.pojo.ExcelMappingObject;
import top.cenze.utils.pojo.ExcelReadException;

public class JxlsExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(JxlsExcelUtil.class);

    public static MultipartFile delWithExclusionRow(MultipartFile file, Integer sheetIndex, Integer startRow, List<Integer> lstExclusionRow) {
        if (ObjectUtil.isNull((Object)file) || ObjectUtil.isNull((Object)sheetIndex) || CollectionUtil.isEmpty(lstExclusionRow)) {
            return null;
        }
        HSSFWorkbook workbook = null;
        if (file.getOriginalFilename().endsWith(".xls")) {
            workbook = new HSSFWorkbook(file.getInputStream());
        }
        if (file.getOriginalFilename().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(file.getInputStream());
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex.intValue());
        int lastRowNum = sheet.getLastRowNum();
        for (int i = startRow.intValue(); i < lastRowNum; ++i) {
            Row row = sheet.getRow(i);
            if (lstExclusionRow.contains(i) || !ObjectUtil.isNull((Object)row)) continue;
            sheet.removeRow(row);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem fileItem = factory.createItem("textField", "text/plain", true, file.getName());
        OutputStream os = fileItem.getOutputStream();
        workbook.write(os);
        return MultipartFileUtil.getMultipartFile(fileItem);
    }

    public static MultipartFile delRow(MultipartFile file, Integer sheetIndex, List<Integer> lstRow) {
        if (ObjectUtil.isNull((Object)file) || ObjectUtil.isNull((Object)sheetIndex) || CollectionUtil.isEmpty(lstRow)) {
            return null;
        }
        HSSFWorkbook workbook = null;
        if (file.getOriginalFilename().endsWith(".xls")) {
            workbook = new HSSFWorkbook(file.getInputStream());
        }
        if (file.getOriginalFilename().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(file.getInputStream());
        }
        Sheet sheet = workbook.getSheetAt(sheetIndex.intValue());
        for (Integer rowIdx : lstRow) {
            Row row = sheet.getRow(rowIdx.intValue());
            if (!ObjectUtil.isNull((Object)row)) continue;
            sheet.removeRow(row);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem fileItem = factory.createItem("textField", "text/plain", true, file.getName());
        OutputStream os = fileItem.getOutputStream();
        workbook.write(os);
        return MultipartFileUtil.getMultipartFile(fileItem);
    }

    public static XLSReadStatus importExcel(MultipartFile file, String templateFilePath, Object items, Boolean skipErrs) {
        InputStream isImportXmlTemplate = CZFileUtil.readFile(templateFilePath);
        InputStream isImportFile = file.getInputStream();
        return JxlsExcelUtil.importExcel(isImportFile, isImportXmlTemplate, items, skipErrs);
    }

    public static XLSReadStatus importExcel(MultipartFile file, byte[] templateFile, Object items, Boolean skipErrs) {
        ByteArrayInputStream isImportXmlTemplate = new ByteArrayInputStream(templateFile);
        InputStream isImportFile = file.getInputStream();
        return JxlsExcelUtil.importExcel(isImportFile, isImportXmlTemplate, items, skipErrs);
    }

    public static XLSReadStatus importExcel(String importFilePath, String templateFilePath, Object items, Boolean skipErrs) {
        InputStream isImportXmlTemplate = CZFileUtil.readFile(templateFilePath);
        InputStream isImportFile = CZFileUtil.readFile(importFilePath);
        return JxlsExcelUtil.importExcel(isImportFile, isImportXmlTemplate, items, skipErrs);
    }

    public static XLSReadStatus importExcel(String importFilePath, byte[] templateFile, Object items, Boolean skipErrs) {
        ByteArrayInputStream isImportXmlTemplate = new ByteArrayInputStream(templateFile);
        InputStream isImportFile = CZFileUtil.readFile(importFilePath);
        return JxlsExcelUtil.importExcel(isImportFile, isImportXmlTemplate, items, skipErrs);
    }

    public static XLSReadStatus importExcel(InputStream isImportFile, InputStream isImportXmlTemplate, Object items, Boolean skipErrs) {
        if (ObjectUtil.isNull((Object)skipErrs)) {
            skipErrs = false;
        }
        log.info("importExcel items: {}", (Object)JSON.toJSONString((Object)items));
        if (ObjectUtil.isNull((Object)isImportFile)) {
            throw new NullArgumentException("\u5f85\u5bfc\u5165\u6570\u636e\u6587\u4ef6\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)isImportXmlTemplate)) {
            throw new NullArgumentException("\u5bfc\u5165\u6a21\u677f\u6d41\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)items)) {
            throw new NullArgumentException("\u8f93\u51fa\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (skipErrs.booleanValue()) {
            ReaderConfig.getInstance().setSkipErrors(true);
        }
        ReaderConfig.getInstance().setUseDefaultValuesForPrimitiveTypes(true);
        XLSReader reader = ReaderBuilder.buildFromXML((InputStream)isImportXmlTemplate);
        reader.getConvertUtilsBeanProvider().getConvertUtilsBean().register((Converter)new ExcelDateConverter(), String.class);
        HashMap<String, Object> beans = new HashMap<String, Object>();
        beans.put("items", items);
        return reader.read(isImportFile, beans);
    }

    public static List<ExcelReadException> getReadExceptions(XLSReadStatus xlsReadStatus) {
        String regex = "[A-Z]+[0-9]+";
        Pattern pattern = Pattern.compile(regex);
        if (ObjectUtil.isNotNull((Object)xlsReadStatus.getReadMessages())) {
            ArrayList<ExcelReadException> lstReadException = new ArrayList<ExcelReadException>();
            JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)xlsReadStatus.getReadMessages()));
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject exception;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                if (ObjectUtil.isNull((Object)jsonObject)) continue;
                ExcelReadException readException = new ExcelReadException();
                String errCell = jsonObject.getString("message");
                log.info("getReadExceptions errCell: {}", (Object)errCell);
                if (StrUtil.isNotEmpty((CharSequence)errCell)) {
                    Matcher matcher = pattern.matcher(errCell);
                    while (matcher.find()) {
                        readException.setExCell(matcher.group());
                    }
                }
                if (ObjectUtil.isNotNull((Object)(exception = jsonObject.getJSONObject("exception")))) {
                    readException.setExMessage(exception.getString("message"));
                }
                lstReadException.add(readException);
            }
            return lstReadException;
        }
        return null;
    }

    public static void exportExcel(String templateFilePath, Object mapperObject, Object mapperLoop, Object mapperFunc, HttpServletResponse response, HttpServletRequest request) {
        File file = new File(templateFilePath);
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        fis.read(bytes);
        fis.close();
        JxlsExcelUtil.exportExcel(bytes, mapperObject, mapperLoop, mapperFunc, response, request);
    }

    public static void exportExcel(byte[] templateFile, Object mapperObject, Object mapperLoop, Object mapperFunc, HttpServletResponse response, HttpServletRequest request) {
        byte[] bytes = JxlsExcelUtil.exportExcel(templateFile, mapperObject, mapperLoop, mapperFunc);
        ServletOutputStream outputStream = response.getOutputStream();
        outputStream.write(bytes);
        outputStream.flush();
        outputStream.close();
    }

    public static byte[] exportExcel(String templateFilePath, Object mapperObject, Object mapperLoop, Object mapperFunc) {
        File file = new File(templateFilePath);
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        fis.read(bytes);
        fis.close();
        return JxlsExcelUtil.exportExcel(bytes, mapperObject, mapperLoop, mapperFunc);
    }

    public static byte[] exportExcel(byte[] templateFile, Object mapperObject, Object mapperLoop, Object mapperFunc) {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ExcelTypeEnum.XLSX.getExtname();
        File tmpFile = CZFileUtil.mkFileToResource(null, templateFileName);
        CZFileUtil.writeFileToResource(tmpFile, templateFile);
        String exportFileName = UUID.randomUUID().toString().replaceAll("-", "") + ExcelTypeEnum.XLSX.getExtname();
        File expFile = CZFileUtil.mkFileToResource(null, exportFileName);
        return JxlsExcelUtil.exportExcel(tmpFile, expFile, mapperObject, mapperLoop, mapperFunc);
    }

    public static byte[] exportExcel(File templateFile, File exportFile, Object mapperObject, Object mapperLoop, Object mapperFunc) {
        MultipartFile file = JxlsExcelUtil.exportExcelToMultiPartFile(templateFile, exportFile, mapperObject, mapperLoop, mapperFunc);
        if (ObjectUtil.isNotNull((Object)file)) {
            return file.getBytes();
        }
        return null;
    }

    public static MultipartFile exportExcelToMultiPartFile(byte[] templateFile, Object mapperObject, Object mapperLoop, Object mapperFunc) {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ExcelTypeEnum.XLSX.getExtname();
        File tmpFile = CZFileUtil.mkFileToResource(null, templateFileName);
        CZFileUtil.writeFileToResource(tmpFile, templateFile);
        String exportFileName = UUID.randomUUID().toString().replaceAll("-", "") + ExcelTypeEnum.XLSX.getExtname();
        File expFile = CZFileUtil.mkFileToResource(null, exportFileName);
        return JxlsExcelUtil.exportExcelToMultiPartFile(tmpFile, expFile, mapperObject, mapperLoop, mapperFunc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MultipartFile exportExcelToMultiPartFile(File templateFile, File exportFile, Object mapperObject, Object mapperLoop, Object mapperFunc) {
        if (!FileUtil.exist((File)templateFile)) throw new Exception("\u6a21\u677f\u6216\u5bfc\u51fa\u6587\u4ef6\u4e0d\u5b58\u5728");
        if (!FileUtil.exist((File)exportFile)) {
            throw new Exception("\u6a21\u677f\u6216\u5bfc\u51fa\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        FileInputStream fis = null;
        OutputStream fos = null;
        try {
            fis = new FileInputStream(templateFile);
            fos = new FileOutputStream(exportFile);
            JxlsHelper jxlsHelper = JxlsHelper.getInstance();
            Transformer trans = jxlsHelper.createTransformer((InputStream)fis, fos);
            if (ObjectUtil.isNotNull((Object)mapperFunc)) {
                HashMap<String, Object> mapFunc = new HashMap<String, Object>();
                mapFunc.put("funcs", mapperFunc);
                JexlExpressionEvaluator evaluator = (JexlExpressionEvaluator)trans.getTransformationConfig().getExpressionEvaluator();
                evaluator.setJexlEngine(new JexlBuilder().namespaces(mapFunc).create());
            }
            Context context = PoiTransformer.createInitialContext();
            if (ObjectUtil.isNotNull((Object)mapperObject)) {
                context.putVar("object", mapperObject);
            }
            if (ObjectUtil.isNotNull((Object)mapperLoop)) {
                context.putVar("items", mapperLoop);
            }
            jxlsHelper.setUseFastFormulaProcessor(false).processTemplate(context, trans);
            MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(exportFile);
            return multipartFile;
        }
        catch (FileNotFoundException fe) {
            log.error("export file not found err: {}", (Object)fe.getMessage());
            throw new Exception(fe.getMessage());
        }
        catch (IOException ie) {
            log.error("export io err: {}", (Object)ie.getMessage());
            throw new Exception(ie.getMessage());
        }
        finally {
            try {
                if (ObjectUtil.isNotNull(fos)) {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                if (ObjectUtil.isNotNull((Object)fis)) {
                    fis.close();
                }
                FileUtil.del((File)templateFile);
                FileUtil.del((File)exportFile);
            }
            catch (IOException e) {
                log.error("export io err: {}", (Object)e.getMessage());
                throw new Exception(e.getMessage());
            }
        }
    }

    private static void addComment(Cell cell, String value, ExcelTypeEnum excelType) {
        if (ObjectUtil.isNull((Object)((Object)excelType))) {
            excelType = ExcelTypeEnum.XLSX;
        }
        Sheet sheet = cell.getSheet();
        cell.removeCellComment();
        if (ExcelTypeEnum.XLS.equals((Object)excelType)) {
            HSSFClientAnchor anchor = new HSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex());
            anchor.setRow2(cell.getRowIndex());
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new HSSFRichTextString(value));
            cell.setCellComment(comment);
        } else if (ExcelTypeEnum.XLSX.equals((Object)excelType)) {
            XSSFClientAnchor anchor = new XSSFClientAnchor();
            anchor.setDx1(0);
            anchor.setDx2(0);
            anchor.setDy1(0);
            anchor.setDy2(0);
            anchor.setCol1(cell.getColumnIndex());
            anchor.setRow1(cell.getRowIndex());
            anchor.setCol2(cell.getColumnIndex());
            anchor.setRow2(cell.getRowIndex());
            Drawing drawing = sheet.createDrawingPatriarch();
            Comment comment = drawing.createCellComment((ClientAnchor)anchor);
            comment.setString((RichTextString)new XSSFRichTextString(value));
            cell.setCellComment(comment);
        }
    }

    public static MultipartFile createExportTemplate(ExcelMapping mapping) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet("Sheet1");
        if (ObjectUtil.isNull((Object)sheet)) {
            throw new NullPointerException("\u521b\u5efasheet\u5931\u8d25");
        }
        HashMap<Integer, Map<Integer, CellStyle>> mapAllStyle = new HashMap<Integer, Map<Integer, CellStyle>>();
        HashMap<Integer, Short> mapAllHeight = new HashMap<Integer, Short>();
        HashMap<Integer, Integer> mapAllWidth = new HashMap<Integer, Integer>();
        JxlsExcelUtil.getSheetStyle((Sheet)sheet, mapAllStyle, mapAllHeight, mapAllWidth);
        Map<Integer, Row> allRow = JxlsExcelUtil.createAllRow((Sheet)sheet, mapping);
        log.info("createExportTemplate allRow size: {}", (Object)allRow.size());
        if (ObjectUtil.isNull((Object)allRow.get(0))) {
            throw new NullPointerException("\u521b\u5efa\u5355\u5143\u683c\u5931\u8d25");
        }
        Cell a1 = allRow.get(0).getCell(0);
        Object a1Style = null;
        if (ObjectUtil.isNull((Object)a1)) {
            allRow.get(0).createCell(0, CellType.STRING);
            a1 = allRow.get(0).getCell(0);
        }
        Map<Integer, Map<Integer, Cell>> allCell = JxlsExcelUtil.createAllCell(allRow, mapping);
        String a1Rich = ConvertUtil.numberToLetter(mapping.getMaxCol()) + (mapping.getMaxRow() + 1);
        JxlsExcelUtil.addComment(a1, "jx:area(lastCell=\"" + a1Rich + "\")", null);
        if (ObjectUtil.isNotNull((Object)a1) && StrUtil.isNotEmpty((CharSequence)a1.getStringCellValue())) {
            a1.setCellValue(a1.getStringCellValue());
        }
        JxlsExcelUtil.setSheetWidthHeight((Sheet)sheet, mapping.getLstRowHeight(), mapping.getLstColWidth());
        JxlsExcelUtil.setSheetStyle((Sheet)sheet, mapAllStyle);
        File tmpFile = CZFileUtil.createExcelTemplateFile();
        FileOutputStream fos = new FileOutputStream(tmpFile);
        workbook.write((OutputStream)fos);
        workbook.close();
        fos.flush();
        fos.close();
        MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(tmpFile);
        FileUtil.del((File)tmpFile);
        return multipartFile;
    }

    public static MultipartFile createExportTemplate(MultipartFile templateFile, ExcelMapping mapping) {
        Sheet sheet;
        log.info("createExportTemplate mapping: {}", (Object)JSON.toJSONString((Object)mapping));
        HSSFWorkbook workbook = null;
        if (templateFile.getOriginalFilename().endsWith(".xls")) {
            workbook = new HSSFWorkbook(templateFile.getInputStream());
        }
        if (templateFile.getOriginalFilename().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(templateFile.getInputStream());
        }
        if (ObjectUtil.isNull((Object)(sheet = workbook.getSheetAt(0)))) {
            throw new NullPointerException("\u52a0\u8f7dsheet\u5931\u8d25");
        }
        HashMap<Integer, Map<Integer, CellStyle>> mapAllStyle = new HashMap<Integer, Map<Integer, CellStyle>>();
        HashMap<Integer, Short> mapAllHeight = new HashMap<Integer, Short>();
        HashMap<Integer, Integer> mapAllWidth = new HashMap<Integer, Integer>();
        JxlsExcelUtil.getSheetStyle(sheet, mapAllStyle, mapAllHeight, mapAllWidth);
        Map<Integer, Row> allRow = JxlsExcelUtil.createAllRow(sheet, mapping);
        log.info("createExportTemplate allRow size: {}", (Object)allRow.size());
        if (ObjectUtil.isNull((Object)allRow.get(0))) {
            throw new NullPointerException("\u521b\u5efa\u5355\u5143\u683c\u5931\u8d25");
        }
        Cell a1 = allRow.get(0).getCell(0);
        Object a1Style = null;
        if (ObjectUtil.isNull((Object)a1)) {
            allRow.get(0).createCell(0, CellType.STRING);
            a1 = allRow.get(0).getCell(0);
        }
        Map<Integer, Map<Integer, Cell>> allCell = JxlsExcelUtil.createAllCell(allRow, mapping);
        String a1Rich = ConvertUtil.numberToLetter(mapping.getMaxCol()) + (mapping.getMaxRow() + 1);
        JxlsExcelUtil.addComment(a1, "jx:area(lastCell=\"" + a1Rich + "\")", null);
        if (ObjectUtil.isNotNull((Object)a1) && StrUtil.isNotEmpty((CharSequence)a1.getStringCellValue())) {
            a1.setCellValue(a1.getStringCellValue());
        }
        JxlsExcelUtil.setSheetWidthHeight(sheet, mapping.getLstRowHeight(), mapping.getLstColWidth());
        JxlsExcelUtil.setSheetStyle(sheet, mapAllStyle);
        File tmpFile = CZFileUtil.createExcelTemplateFile();
        FileOutputStream fos = new FileOutputStream(tmpFile);
        workbook.write((OutputStream)fos);
        workbook.close();
        fos.flush();
        fos.close();
        MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(tmpFile);
        FileUtil.del((File)tmpFile);
        return multipartFile;
    }

    public static ExcelMapping getTemplateFileMaxRowAndCol(MultipartFile templateFile) {
        Sheet sheet;
        HSSFWorkbook workbook = null;
        if (templateFile.getOriginalFilename().endsWith(".xls")) {
            workbook = new HSSFWorkbook(templateFile.getInputStream());
        }
        if (templateFile.getOriginalFilename().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(templateFile.getInputStream());
        }
        if (ObjectUtil.isNull((Object)(sheet = workbook.getSheetAt(0)))) {
            throw new NullPointerException("\u52a0\u8f7dsheet\u5931\u8d25");
        }
        int maxRow = sheet.getLastRowNum();
        short maxCol = 0;
        for (int i = 0; i < maxRow + 1; ++i) {
            short lastCellNum;
            Row row = sheet.getRow(i);
            if (!ObjectUtil.isNotNull((Object)row) || (lastCellNum = row.getLastCellNum()) <= maxCol) continue;
            maxCol = lastCellNum;
        }
        ExcelMapping mapping = new ExcelMapping();
        mapping.setMaxRow(maxRow);
        mapping.setMaxCol(Integer.valueOf(maxCol));
        return mapping;
    }

    private static void getSheetStyle(Sheet sheet, Map<Integer, Map<Integer, CellStyle>> mapAllStyle, Map<Integer, Short> mapAllHeight, Map<Integer, Integer> mapAllWidth) {
        int maxRow = sheet.getLastRowNum();
        short maxCol = 0;
        log.info("getSheetStyle maxRow: {}", (Object)maxRow);
        if (maxRow < 0) {
            return;
        }
        for (int r = 0; r < maxRow + 1; ++r) {
            Row row = sheet.getRow(r);
            if (ObjectUtil.isNull((Object)row)) {
                row = sheet.createRow(r);
            }
            mapAllHeight.put(r, row.getHeight());
            short cols = row.getLastCellNum();
            log.info("getSheetStyle cols: {}", (Object)cols);
            if (cols > maxCol) {
                maxCol = cols;
            }
            HashMap<Integer, CellStyle> mapStyle = new HashMap<Integer, CellStyle>();
            for (int c = 0; c < cols + 1; ++c) {
                CellStyle cellStyle;
                Cell cell = row.getCell(c);
                if (ObjectUtil.isNull((Object)cell) || !ObjectUtil.isNotNull((Object)(cellStyle = cell.getCellStyle()))) continue;
                mapStyle.put(c, cellStyle);
            }
            if (!CollectionUtil.isNotEmpty(mapStyle)) continue;
            mapAllStyle.put(r, mapStyle);
        }
        log.info("getSheetStyle maxCol: {}", (Object)maxCol);
        for (int c = 0; c < maxCol + 1; ++c) {
            if (ObjectUtil.isNull((Object)sheet.getRow(0).getCell(c))) {
                sheet.getRow(0).createCell(c, CellType.STRING);
            }
            mapAllWidth.put(c, sheet.getColumnWidth(c));
        }
        log.info("getSheetStyle allHeight: {}", (Object)JSON.toJSONString(mapAllHeight));
        log.info("getSheetStyle allWidth: {}", (Object)JSON.toJSONString(mapAllWidth));
    }

    private static void setSheetStyle(Sheet sheet, Map<Integer, Map<Integer, CellStyle>> mapAllStyle) {
        if (ObjectUtil.isNull((Object)sheet) || CollectionUtil.isEmpty(mapAllStyle)) {
            return;
        }
        for (Map.Entry<Integer, Map<Integer, CellStyle>> entry : mapAllStyle.entrySet()) {
            Integer r = entry.getKey();
            Map<Integer, CellStyle> mapStyle = entry.getValue();
            if (CollectionUtil.isEmpty(mapStyle)) continue;
            for (Map.Entry<Integer, CellStyle> e : mapStyle.entrySet()) {
                Integer c = e.getKey();
                CellStyle style = e.getValue();
                if (ObjectUtil.isNull((Object)style)) continue;
                sheet.getRow(r.intValue()).getCell(c.intValue()).setCellStyle(style);
            }
        }
    }

    private static void setSheetWidthHeight(Sheet sheet, Map<Integer, Short> mapAllHeight, Map<Integer, Integer> mapAllWidth) {
        if (ObjectUtil.isNull((Object)sheet)) {
            return;
        }
        if (CollectionUtil.isNotEmpty(mapAllHeight)) {
            for (Map.Entry<Integer, Number> entry : mapAllHeight.entrySet()) {
                if (ObjectUtil.isNull(entry)) continue;
                sheet.getRow(entry.getKey().intValue()).setHeight(((Short)entry.getValue()).shortValue());
            }
        }
        if (CollectionUtil.isNotEmpty(mapAllWidth)) {
            for (Map.Entry<Integer, Number> entry : mapAllWidth.entrySet()) {
                if (ObjectUtil.isNull(entry)) continue;
                sheet.setColumnWidth(entry.getKey().intValue(), ((Integer)entry.getValue()).intValue());
            }
        }
    }

    private static void setSheetWidthHeight(Sheet sheet, List<Short> lstRowHeight, List<Short> lstColWidth) {
        short pre;
        if (ObjectUtil.isNull((Object)sheet)) {
            return;
        }
        if (CollectionUtil.isNotEmpty(lstRowHeight)) {
            pre = 0;
            for (int r = 0; r < lstRowHeight.size(); ++r) {
                Row row = sheet.getRow(r);
                if (ObjectUtil.isNull((Object)row)) {
                    row = sheet.createRow(r);
                }
                row.setHeight(Convert.toShort((Object)((lstRowHeight.get(r) - pre) * 20)).shortValue());
                pre = lstRowHeight.get(r);
            }
        }
        if (CollectionUtil.isNotEmpty(lstColWidth)) {
            pre = 0;
            for (int c = 0; c < lstColWidth.size(); ++c) {
                Cell cell = sheet.getRow(0).getCell(c);
                if (ObjectUtil.isNull((Object)cell)) {
                    cell = sheet.getRow(0).createCell(c);
                }
                sheet.setColumnWidth(c, Convert.toInt((Object)((double)(lstColWidth.get(c) - pre) * 26.4)).intValue());
                pre = lstColWidth.get(c);
            }
        }
    }

    private static Map<Integer, Row> createAllRow(Sheet sheet, ExcelMapping mapping) {
        Set setRows;
        if (ObjectUtil.isNull((Object)sheet) || ObjectUtil.isNull((Object)mapping)) {
            return null;
        }
        HashMap<Integer, Row> mapAllRows = new HashMap<Integer, Row>();
        HashSet<Object> rows = new HashSet<Object>();
        if (CollectionUtil.isNotEmpty(mapping.getLstCustom()) && CollectionUtil.isNotEmpty(setRows = mapping.getLstCustom().stream().map(ExcelMappingCustom::getRow).collect(Collectors.toSet()))) {
            rows.addAll(setRows);
        }
        if (CollectionUtil.isNotEmpty(mapping.getLstObject()) && CollectionUtil.isNotEmpty(setRows = mapping.getLstObject().stream().map(ExcelMappingObject::getRow).collect(Collectors.toSet()))) {
            rows.addAll(setRows);
        }
        if (ObjectUtil.isNotNull((Object)mapping.getMappingLoop()) && CollectionUtil.isNotEmpty(mapping.getMappingLoop().getLstData()) && CollectionUtil.isNotEmpty(setRows = mapping.getMappingLoop().getLstData().stream().map(ExcelMappingObject::getRow).collect(Collectors.toSet()))) {
            rows.addAll(setRows);
        }
        if (CollectionUtil.isEmpty(rows) || !rows.contains(0)) {
            rows.add(0);
        }
        for (Integer n : rows) {
            Row excelRow = sheet.getRow(n.intValue());
            if (ObjectUtil.isNull((Object)excelRow)) {
                excelRow = sheet.createRow(n.intValue());
            }
            if (!ObjectUtil.isNotNull((Object)excelRow)) continue;
            mapAllRows.put(n, excelRow);
        }
        return mapAllRows;
    }

    private static Map<Integer, Map<Integer, Cell>> createAllCell(Map<Integer, Row> mapAllRows, ExcelMapping mapping) {
        Map mapCells;
        Row row;
        if (CollectionUtil.isEmpty(mapAllRows) || ObjectUtil.isNull((Object)mapping)) {
            return null;
        }
        HashMap<Integer, Map<Integer, Cell>> mapAllCells = new HashMap<Integer, Map<Integer, Cell>>();
        if (CollectionUtil.isNotEmpty(mapping.getLstCustom())) {
            for (ExcelMappingCustom custom : mapping.getLstCustom()) {
                Cell cell;
                row = mapAllRows.get(custom.getRow());
                if (ObjectUtil.isNull((Object)row)) {
                    throw new NullPointerException("\u884c\u5355\u5143\u683c\u6a21\u677f\u672a\u627e\u5230");
                }
                mapCells = (HashMap)mapAllCells.get(custom.getRow());
                if (CollectionUtil.isEmpty((Map)mapCells)) {
                    mapCells = new HashMap();
                }
                if (ObjectUtil.isNull((Object)(cell = row.getCell(custom.getCol().intValue())))) {
                    cell = row.createCell(custom.getCol().intValue(), CellType.STRING);
                }
                CellStyle cellStyle = cell.getCellStyle();
                cell.setCellValue(custom.getContent());
                if (ObjectUtil.isNotNull((Object)cellStyle)) {
                    cell.setCellStyle(cellStyle);
                }
                mapCells.put(custom.getCol(), cell);
                mapAllCells.put(custom.getRow(), mapCells);
            }
        }
        if (CollectionUtil.isNotEmpty(mapping.getLstObject())) {
            for (ExcelMappingObject object : mapping.getLstObject()) {
                row = mapAllRows.get(object.getRow());
                if (ObjectUtil.isNull((Object)row)) {
                    throw new NullPointerException("\u884c\u5355\u5143\u683c\u6a21\u677f\u672a\u627e\u5230");
                }
                mapCells = (Map)mapAllCells.get(object.getRow());
                if (CollectionUtil.isEmpty((Map)mapCells)) {
                    mapCells = new HashMap();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("${object.").append(object.getObjectItemName()).append("}");
                Cell cell = row.getCell(object.getCol().intValue());
                if (ObjectUtil.isNull((Object)cell)) {
                    cell = row.createCell(object.getCol().intValue(), CellType.STRING);
                }
                CellStyle cellStyle = cell.getCellStyle();
                cell.setCellValue(sb.toString());
                if (ObjectUtil.isNotNull((Object)cellStyle)) {
                    cell.setCellStyle(cellStyle);
                }
                mapCells.put(object.getCol(), cell);
                mapAllCells.put(object.getRow(), mapCells);
            }
        }
        if (ObjectUtil.isNotNull((Object)mapping.getMappingLoop()) && CollectionUtil.isNotEmpty(mapping.getMappingLoop().getLstData())) {
            Row row2;
            List<ExcelMappingObject> lstData = mapping.getMappingLoop().getLstData();
            Integer minCol = lstData.stream().map(ExcelMappingObject::getCol).min((v1, v2) -> v1 - v2).get();
            Integer maxCol = lstData.stream().map(ExcelMappingObject::getCol).max((v1, v2) -> v1 - v2).get();
            if (ObjectUtil.isNull((Object)minCol)) {
                minCol = 0;
            }
            for (ExcelMappingObject object : lstData) {
                row2 = mapAllRows.get(object.getRow());
                if (ObjectUtil.isNull((Object)row2)) {
                    throw new NullPointerException("\u884c\u5355\u5143\u683c\u6a21\u677f\u672a\u627e\u5230");
                }
                HashMap<Integer, Cell> mapCells2 = (HashMap<Integer, Cell>)mapAllCells.get(object.getRow());
                if (CollectionUtil.isEmpty((Map)mapCells2)) {
                    mapCells2 = new HashMap<Integer, Cell>();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("${item.").append(object.getObjectItemName()).append("}");
                Cell cell = row2.getCell(object.getCol().intValue());
                if (ObjectUtil.isNull((Object)cell)) {
                    cell = row2.createCell(object.getCol().intValue(), CellType.STRING);
                }
                CellStyle cellStyle = cell.getCellStyle();
                cell.setCellValue(sb.toString());
                if (ObjectUtil.isNotNull((Object)cellStyle)) {
                    cell.setCellStyle(cellStyle);
                }
                mapCells2.put(object.getCol(), cell);
                mapAllCells.put(object.getRow(), mapCells2);
            }
            String loopRich = ConvertUtil.numberToLetter(mapping.getMaxCol()) + (mapping.getMappingLoop().getMaxRow() + 1);
            Cell firstLoopCell = (Cell)((Map)mapAllCells.get(mapping.getMappingLoop().getMinRow())).get(minCol);
            if (ObjectUtil.isNull((Object)firstLoopCell)) {
                row2 = mapAllRows.get(mapping.getMappingLoop().getMinRow());
                if (ObjectUtil.isNull((Object)row2)) {
                    throw new NullPointerException("\u884c\u5355\u5143\u683c\u6a21\u677f\u672a\u627e\u5230");
                }
                firstLoopCell = row2.createCell(minCol.intValue(), CellType.STRING);
            }
            JxlsExcelUtil.addComment(firstLoopCell, "jx:each(items=\"items\" var=\"item\" lastCell=\"" + loopRich + "\")", null);
        }
        return mapAllCells;
    }

    public static MultipartFile createImportXmlToMultipartFile(ExcelMapping mapping) {
        Document xml = JxlsExcelUtil.createImportXml(mapping);
        if (ObjectUtil.isNull((Object)xml)) {
            return null;
        }
        File tmpFile = XMLUtil.toFile(xml);
        MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(tmpFile);
        FileUtil.del((File)tmpFile);
        return multipartFile;
    }

    public static Document createImportXml(ExcelMapping mapping) {
        if (ObjectUtil.isNull((Object)mapping) || ObjectUtil.isNull((Object)mapping.getMappingLoop())) {
            throw new NullArgumentException("\u6620\u5c04\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Document xml = XmlUtil.createXml();
        Element workbook = xml.createElement("workbook");
        if (ObjectUtil.isNull((Object)mapping.getSheetIndex())) {
            mapping.setSheetIndex(0);
        }
        Element worksheet = xml.createElement("worksheet");
        worksheet.setAttribute("idx", Convert.toStr((Object)mapping.getSheetIndex()));
        Element exclusionSection = JxlsExcelUtil.createExclusionSection(xml, 0, mapping.getMappingLoop().getMinRow());
        worksheet.appendChild(exclusionSection);
        Element loop = JxlsExcelUtil.createElementLoop(xml, mapping.getMappingLoop());
        worksheet.appendChild(loop);
        workbook.appendChild(worksheet);
        xml.appendChild(workbook);
        return xml;
    }

    private static Element createElementLoop(Document xml, ExcelMappingLoop mappingLoop) {
        Integer startRow = mappingLoop.getMinRow();
        Integer endRow = mappingLoop.getMaxRow();
        System.out.println("createElementLoop endRow: " + endRow);
        String varType = mappingLoop.getVarType();
        if (StrUtil.isEmpty((CharSequence)varType)) {
            throw new NullArgumentException("\u5fc5\u987b\u6307\u5b9a\u6620\u5c04\u5bf9\u8c61\u7684\u5168\u7c7b\u540d");
        }
        Element loop = xml.createElement("loop");
        loop.setAttribute("startRow", Convert.toStr((Object)startRow));
        loop.setAttribute("endRow", Convert.toStr((Object)endRow));
        loop.setAttribute("items", "items");
        loop.setAttribute("var", "item");
        loop.setAttribute("varType", varType);
        Element sectionData = xml.createElement("section");
        sectionData.setAttribute("startRow", Convert.toStr((Object)startRow));
        sectionData.setAttribute("endRow", Convert.toStr((Object)endRow));
        for (ExcelMappingObject item : mappingLoop.getLstData()) {
            Element mapping = xml.createElement("mapping");
            mapping.setAttribute("row", Convert.toStr((Object)item.getRow()));
            mapping.setAttribute("col", Convert.toStr((Object)item.getCol()));
            mapping.setTextContent("item." + item.getObjectItemName());
            sectionData.appendChild(mapping);
        }
        Element loopbreakcondition = xml.createElement("loopbreakcondition");
        Element rowcheck = xml.createElement("rowcheck");
        rowcheck.setAttribute("offset", "0");
        for (ExcelMappingObject item : mappingLoop.getLstData()) {
            Element cellcheck = xml.createElement("cellcheck");
            cellcheck.setAttribute("offset", Convert.toStr((Object)item.getCol()));
            rowcheck.appendChild(cellcheck);
        }
        loopbreakcondition.appendChild(rowcheck);
        loop.appendChild(loopbreakcondition);
        loop.appendChild(sectionData);
        return loop;
    }

    private static Element createExclusionSection(Document xml, Integer startRow, Integer endRow) {
        Element sectionExclusion = xml.createElement("section");
        sectionExclusion.setAttribute("startRow", Convert.toStr((Object)startRow));
        if (ObjectUtil.isNotNull((Object)endRow) && endRow > 0) {
            sectionExclusion.setAttribute("endRow", Convert.toStr((Object)(endRow - 1)));
        } else {
            sectionExclusion.setAttribute("endRow", "0");
        }
        return sectionExclusion;
    }

    public static List<ExcelFieldInfo> readExcelByRow(MultipartFile file, Integer sheetIdx, Integer row) {
        Sheet sheet;
        int lastRowNum;
        if (ObjectUtil.isNull((Object)sheetIdx)) {
            sheetIdx = 0;
        }
        if (ObjectUtil.isNull((Object)row)) {
            row = 1;
        }
        HSSFWorkbook workbook = null;
        if (file.getOriginalFilename().endsWith(".xls")) {
            workbook = new HSSFWorkbook(file.getInputStream());
        }
        if (file.getOriginalFilename().endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(file.getInputStream());
        }
        if ((lastRowNum = (sheet = workbook.getSheetAt(sheetIdx.intValue())).getLastRowNum()) < 0) {
            throw new Exception("Excel\u6587\u4ef6Sheet\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int rowIdx = row - 1;
        if (rowIdx > lastRowNum || rowIdx < 0) {
            throw new Exception("\u6307\u5b9a\u5b57\u6bb5\u540d\u884c\u6570\u4e0d\u6b63\u786e");
        }
        Row r = sheet.getRow(rowIdx);
        if (ObjectUtil.isNull((Object)r)) {
            throw new Exception("\u6307\u5b9a\u5b57\u6bb5\u540d\u884c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int lastCellNum = r.getLastCellNum();
        if (lastCellNum < 0) {
            throw new Exception("\u6307\u5b9a\u5b57\u6bb5\u540d\u884c\u6570\u636e\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<ExcelFieldInfo> lstFields = new ArrayList<ExcelFieldInfo>();
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = r.getCell(i);
            String cellVal = JxlsExcelUtil.getCellValueByCell(cell);
            if (StrUtil.isEmpty((CharSequence)cellVal)) continue;
            ExcelFieldInfo fieldInfo = new ExcelFieldInfo();
            ConvertUtil.numberToLetter(i);
            fieldInfo.setCell(ConvertUtil.numberToLetter(i) + row);
            fieldInfo.setRowIdx(rowIdx);
            fieldInfo.setColIdx(i);
            fieldInfo.setFieldName(cellVal);
            lstFields.add(fieldInfo);
        }
        return lstFields;
    }

    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    String dtFormat = "yyyy-MM-dd HH:mm:ss";
                    dtFormat = format == 20 || format == 32 ? "HH:mm" : (format == 14 || format == 31 || format == 57 || format == 58 ? "yyyy-MM-dd" : (format == 179 ? "HH:mm:ss" : "yyyy-MM-dd HH:mm:ss"));
                    cellValue = DateUtil.format((Date)cell.getDateCellValue(), (String)dtFormat);
                    break;
                }
                cell.setCellType(CellType.STRING);
                cellValue = cell.getStringCellValue();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            case FORMULA: {
                cell.setCellType(CellType.STRING);
                cellValue = cell.getStringCellValue();
                break;
            }
            case BLANK: {
                cellValue = "";
                break;
            }
            case ERROR: {
                cellValue = "ERROR VALUE";
                break;
            }
            default: {
                cellValue = "UNKNOWN VALUE";
            }
        }
        return cellValue;
    }

    public static String toDateDash(String val) {
        if (StrUtil.isNotEmpty((CharSequence)val)) {
            Double date = Convert.toDouble((Object)val);
            System.out.println("toDate: " + date);
            return DateUtil.format((Date)org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)date), (String)"yyyy-MM-dd HH:mm:ss");
        }
        return val;
    }

    public static String toDate(String val) {
        if (StrUtil.isNotEmpty((CharSequence)val)) {
            if (StrUtil.contains((CharSequence)val, (CharSequence)"-")) {
                return val;
            }
            if (StrUtil.contains((CharSequence)val, (CharSequence)"/")) {
                return val.replaceAll("/", "-");
            }
            if (StrUtil.contains((CharSequence)val, (CharSequence)"\\\\")) {
                return val.replaceAll("\\\\", "-");
            }
            Double date = Convert.toDouble((Object)val);
            return JxlsExcelUtil.doubleToDate(date);
        }
        return val;
    }

    public static String doubleToDate(Double date) {
        int zoneOffset;
        Calendar calendar = Calendar.getInstance();
        TimeZone itTimeZone = TimeZone.getTimeZone("Asia/Shanghai");
        calendar.setTimeZone(itTimeZone);
        int dstOffset = calendar.get(16);
        int localOffset = zoneOffset = calendar.get(15);
        Date tDate = new Date();
        tDate.setTime((long)((date - 25569.0) * 24.0 * 3600.0 * 1000.0 - (double)localOffset));
        return DateUtil.format((Date)tDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String toDateSlash(String val) {
        if (StrUtil.isNotEmpty((CharSequence)val)) {
            Double date = Convert.toDouble((Object)val);
            System.out.println("toDate: " + date);
            return DateUtil.format((Date)org.apache.poi.ss.usermodel.DateUtil.getJavaDate((double)date), (String)"yyyy/MM/dd HH:mm:ss");
        }
        return val;
    }

    public Object formatDate(Date dt) {
        if (ObjectUtil.isNotNull((Object)dt)) {
            String dateStr = DateUtil.format((Date)dt, (String)"yyyy-MM-dd HH:mm:ss");
            return dateStr;
        }
        return "--";
    }

    public Object timeChange(Long time) {
        if (time != null) {
            DecimalFormat df = new DecimalFormat("0.00");
            String result = df.format((double)time.longValue() / 1000.0);
            return result.equals("0.00") ? "--" : result + "s";
        }
        return "--";
    }

    public WritableCellValue myLink(String address, String title) {
        return new WritableHyperlink(address, title);
    }

    public String getTitle() {
        return "\u5bfc\u51fa\u6536\u8d27\u4eba";
    }
}

