/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.util.StrUtil;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public final class PinyinUtil {
    private static HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();

    public static String spell(String src) {
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuffer sb = new StringBuffer();
        int strLength = src.length();
        try {
            for (int i = 0; i < strLength; ++i) {
                String[] arr;
                char ch = src.charAt(i);
                if (ch >= 'a' && ch <= 'z') {
                    sb.append((char)(ch - 97 + 65));
                }
                if (ch >= 'A' && ch <= 'Z') {
                    sb.append(ch);
                }
                if ((arr = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)format)) == null || arr.length <= 0) continue;
                sb.append(arr[0]).append(" ");
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String spellWithTone(String src) {
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITH_TONE_MARK);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        if (src == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < src.length(); ++i) {
                String[] arr;
                char ch = src.charAt(i);
                if (ch >= 'a' && ch <= 'z') {
                    sb.append((char)(ch - 97 + 65));
                }
                if (ch >= 'A' && ch <= 'Z') {
                    sb.append(ch);
                }
                if ((arr = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)format)) == null || arr.length == 0) continue;
                String s = arr[0];
                char c = s.charAt(0);
                String pinyin = String.valueOf(c).toUpperCase().concat(s.substring(1));
                sb.append(pinyin).append(" ");
            }
            return sb.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String spellNoneTone(String src) {
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        if (src == null) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < src.length(); ++i) {
                String[] arr;
                char ch = src.charAt(i);
                if (ch >= 'a' && ch <= 'z') {
                    sb.append((char)(ch - 97 + 65));
                }
                if (ch >= 'A' && ch <= 'Z') {
                    sb.append(ch);
                }
                if ((arr = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)format)) == null || arr.length == 0) continue;
                String s = arr[0];
                char c = s.charAt(0);
                String pinyin = String.valueOf(c).toUpperCase();
                sb.append(pinyin).append("");
            }
            return sb.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTerm(String src) {
        String res = PinyinUtil.spell(src);
        if (res != null && res.length() > 0) {
            return res.toUpperCase().charAt(0) + "";
        }
        return "OT";
    }

    public static String toPinYin(String inputString) {
        if (StrUtil.isEmpty((CharSequence)inputString)) {
            return null;
        }
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        char[] input = inputString.trim().toCharArray();
        StringBuffer output = new StringBuffer("");
        try {
            for (int i = 0; i < input.length; ++i) {
                if (Character.toString(input[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)input[i], (HanyuPinyinOutputFormat)format);
                    output.append(temp[0]);
                    continue;
                }
                output.append(Character.toString(input[i]));
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return output.toString();
    }
}

