/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import top.cenze.utils.pojo.ClassFieldInfo;
import top.cenze.utils.pojo.ClassFields;

public class ReflectionUtil {
    public static <T> ClassFields getAllFields(Class<T> clazz) {
        return ReflectionUtil.getFields(clazz, null);
    }

    public static <T> ClassFields getExistApiModelPropertyFields(Class<T> clazz) {
        return ReflectionUtil.getFields(clazz, true);
    }

    public static <T> ClassFields getNotExistApiModelPropertyFields(Class<T> clazz) {
        return ReflectionUtil.getFields(clazz, false);
    }

    public static <T> ClassFields getFields(Class<T> clazz, Boolean existApiModelProperty) {
        List<ClassFieldInfo> lstClassFieldInfo;
        Field[] declaredFields;
        List<ClassFieldInfo> lstClassFieldInfo2;
        ClassFields classFields = new ClassFields();
        Field[] fields = clazz.getFields();
        if (ObjectUtil.isNotNull((Object)fields) && CollectionUtil.isNotEmpty(lstClassFieldInfo2 = ReflectionUtil.getFieldsAndSwaggerModelPropertyValue(fields, true, existApiModelProperty))) {
            classFields.setLstParentField(lstClassFieldInfo2);
        }
        if (ObjectUtil.isNotNull((Object)(declaredFields = clazz.getDeclaredFields())) && CollectionUtil.isNotEmpty(lstClassFieldInfo = ReflectionUtil.getFieldsAndSwaggerModelPropertyValue(declaredFields, false, existApiModelProperty))) {
            classFields.setLstDeclaredField(lstClassFieldInfo);
        }
        return classFields;
    }

    private static List<ClassFieldInfo> getFieldsAndSwaggerModelPropertyValue(Field[] fields, Boolean isParent, Boolean existApiModelProperty) {
        if (ObjectUtil.isNull((Object)isParent)) {
            isParent = false;
        }
        ArrayList<ClassFieldInfo> lstClassFieldInfo = new ArrayList<ClassFieldInfo>();
        if (ObjectUtil.isNotNull((Object)fields)) {
            for (Field field : fields) {
                field.setAccessible(true);
                ApiModelProperty annotation = field.getDeclaredAnnotation(ApiModelProperty.class);
                ClassFieldInfo classFieldInfo = new ClassFieldInfo();
                classFieldInfo.setField(field.getName());
                classFieldInfo.setType(field.getType().getName());
                classFieldInfo.setName(ReflectionUtil.getFieldSwaggerModelPropertyValue(annotation));
                classFieldInfo.setRequired(ReflectionUtil.getFieldSwaggerModelPropertyRequired(annotation));
                classFieldInfo.setIsParent(isParent);
                if (!existApiModelProperty.booleanValue() && ObjectUtil.isNull((Object)annotation)) {
                    lstClassFieldInfo.add(classFieldInfo);
                    continue;
                }
                if (existApiModelProperty.booleanValue() && ObjectUtil.isNotNull((Object)annotation)) {
                    lstClassFieldInfo.add(classFieldInfo);
                    continue;
                }
                lstClassFieldInfo.add(classFieldInfo);
            }
        }
        return lstClassFieldInfo;
    }

    private static String getFieldSwaggerModelPropertyValue(ApiModelProperty annotation) {
        if (ObjectUtil.isNotNull((Object)annotation)) {
            return annotation.value();
        }
        return null;
    }

    private static boolean getFieldSwaggerModelPropertyRequired(ApiModelProperty annotation) {
        if (ObjectUtil.isNotNull((Object)annotation)) {
            return annotation.required();
        }
        return false;
    }

    private static String getFieldSwaggerModelPropertyValue(Field field) {
        ApiModelProperty annotation = field.getDeclaredAnnotation(ApiModelProperty.class);
        if (ObjectUtil.isNotNull((Object)annotation)) {
            return annotation.value();
        }
        return null;
    }
}

