/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;

public class SFTPUtil {
    protected static final int CLIENT_TIMEOUT = 180000;
    private static ChannelSftp sftp = null;
    private static String username = null;
    private static String password = null;
    private static String host = null;
    private static Integer port = null;
    private static String privateKey = null;

    public static void login(String _username, String _password, String _host, int _port) {
        username = _username;
        password = _password;
        host = _host;
        port = _port;
        SFTPUtil.login();
    }

    public static void login(String _username, String _host, int _port, String _privateKey) {
        username = _username;
        host = _host;
        port = _port;
        privateKey = _privateKey;
        SFTPUtil.login();
    }

    private static void login() {
        if (StrUtil.isEmpty((CharSequence)username) || StrUtil.isEmpty((CharSequence)host) || ObjectUtil.isNull((Object)port)) {
            throw new RuntimeException("\u767b\u5f55\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            JSch jSch = new JSch();
            Session session = jSch.getSession(username, host, port.intValue());
            session.setTimeout(180000);
            if (StrUtil.isNotEmpty((CharSequence)privateKey)) {
                jSch.addIdentity(privateKey);
            } else if (StrUtil.isNotEmpty((CharSequence)password)) {
                session.setPassword(password);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect();
            Channel channel = session.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
        }
        catch (JSchException e) {
            throw new RuntimeException("\u767b\u5f55SFTP\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public static void logout() {
        if (ObjectUtil.isNotNull((Object)sftp) && sftp.isConnected()) {
            sftp.disconnect();
        }
        if (ObjectUtil.isNotNull((Object)sftp.getSession()) && sftp.getSession().isConnected()) {
            sftp.getSession().disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean upload(String dirPath, String sftpFileName, InputStream input) {
        boolean success = false;
        if (ObjectUtil.isNull((Object)sftp) || !sftp.isConnected()) {
            SFTPUtil.login();
        }
        try {
            sftp.cd(dirPath);
        }
        catch (SftpException e) {
            String[] dirs = dirPath.split("/");
            String tempPath = "";
            for (String dir : dirs) {
                if (null == dir || "".equals(dir)) continue;
                tempPath = tempPath + "/" + dir;
                try {
                    sftp.cd(tempPath);
                }
                catch (SftpException O1) {
                    try {
                        sftp.mkdir(tempPath);
                        sftp.cd(tempPath);
                    }
                    catch (SftpException sftpException) {
                        // empty catch block
                    }
                }
                try {
                    sftp.cd(tempPath);
                }
                catch (SftpException sftpException) {
                    // empty catch block
                }
            }
        }
        try {
            sftp.put(input, sftpFileName);
        }
        catch (SftpException e) {
            success = false;
        }
        finally {
            SFTPUtil.logout();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean download(String host, int port, String username, String password, String filePath, OutputStream outputStream) {
        boolean downloaded = true;
        String fileName = null;
        if (ObjectUtil.isNull((Object)sftp) || !sftp.isConnected()) {
            SFTPUtil.login();
        }
        try {
            if (filePath != null && !"".equals(filePath)) {
                String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
                sftp.cd(directory);
            }
            fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            sftp.get(fileName, outputStream);
        }
        catch (SftpException e) {
            downloaded = false;
        }
        finally {
            SFTPUtil.logout();
        }
        return downloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(String filePath) {
        boolean success = true;
        if (ObjectUtil.isNull((Object)sftp) || !sftp.isConnected()) {
            SFTPUtil.login();
        }
        try {
            String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
            sftp.cd(directory);
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            sftp.rm(fileName);
        }
        catch (SftpException e) {
            success = false;
        }
        finally {
            SFTPUtil.logout();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileExist(String host, int port, String username, String password, String filePath) {
        boolean success = false;
        if (ObjectUtil.isNull((Object)sftp) || !sftp.isConnected()) {
            SFTPUtil.login();
        }
        try {
            String directory = filePath.substring(0, filePath.lastIndexOf(File.separator));
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            Vector vector = sftp.ls(directory);
            for (Object obj : vector) {
                ChannelSftp.LsEntry lsEntry;
                if (obj == null || !fileName.equals((lsEntry = (ChannelSftp.LsEntry)obj).getFilename())) continue;
                success = true;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            SFTPUtil.logout();
        }
        return success;
    }
}

