/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

public class SnowflakeUtil {
    private static final int fleetBit = 5;
    private static final int machineBit = 5;
    private static final int sequenceBit = 12;
    private static final int machineDisplacement = 12;
    private static final int fleetDisplacement = 17;
    private static final int timeDisplacement = 22;
    private static final long referenceTime = 1514736000000L;
    private static final int sequenceMax = 4095;
    private static int sequence = 0;
    private static long lastTimeStamp = -1L;

    public static synchronized long getNextId(int fleetCode, int machineCode) {
        long currentTimeStamp = SnowflakeUtil.getCurrentTimeStamp();
        if (lastTimeStamp == currentTimeStamp) {
            if (sequence >= 4095) {
                lastTimeStamp = currentTimeStamp = SnowflakeUtil.getNextTimeStamp();
                sequence = 0;
            } else {
                ++sequence;
            }
        } else if (lastTimeStamp < currentTimeStamp) {
            sequence = 0;
            lastTimeStamp = currentTimeStamp;
        } else if (lastTimeStamp > currentTimeStamp) {
            // empty if block
        }
        long id = currentTimeStamp - 1514736000000L << 22 | (long)(fleetCode << 17) | (long)(machineCode << 12) | (long)sequence;
        return id;
    }

    private static long getCurrentTimeStamp() {
        return System.currentTimeMillis();
    }

    private static long getNextTimeStamp() {
        long timeStamp = SnowflakeUtil.getCurrentTimeStamp();
        while (timeStamp <= lastTimeStamp) {
            timeStamp = SnowflakeUtil.getCurrentTimeStamp();
        }
        return timeStamp;
    }
}

