/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.utils.Base64Util;
import top.cenze.utils.crypt.HMacUtil;

public class TokenUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);

    public static String resolveBearerTokenFromRequest(HttpServletRequest request) throws AuthenticationException {
        String authorization = request.getHeader("Authorization");
        return TokenUtil.resolveBearerTokenFromAuthorization(authorization);
    }

    public static String resolveBearerTokenFromAuthorization(String authorization) throws AuthenticationException {
        log.info("resolveBearerTokenFromAuthorization authorization: {}", (Object)authorization);
        Pattern authorizationPattern = Pattern.compile("^Bearer (?<token>[a-zA-Z0-9-:._~+/]+=*)$", 2);
        if (!StringUtils.startsWithIgnoreCase((CharSequence)authorization, (CharSequence)"bearer")) {
            return null;
        }
        Matcher matcher = authorizationPattern.matcher(authorization);
        if (!matcher.matches()) {
            throw new AuthenticationException("Bearer token is malformed");
        }
        return matcher.group("token");
    }

    public static String createHS256JWTToken(String appId, String appSecret) {
        return TokenUtil.createHS256JWTToken(appId, appSecret, null);
    }

    public static String createHS256JWTToken(String appId, String appSecret, Long iat) {
        log.info("createHS256JWTToken appId: {}, appSecret: {}, iat: {}", new Object[]{appId, appSecret, iat});
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        header.put("alg", "HS256");
        header.put("typ", "JWT");
        if (ObjectUtil.isNull((Object)iat)) {
            iat = System.currentTimeMillis() / 1000L;
        }
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("sub", appId);
        payload.put("iat", iat);
        String data = Base64Util.urlEncode(header) + "." + Base64Util.urlEncode(payload);
        log.info("createHS256JWTToken data: {}", (Object)data);
        return data + "." + HMacUtil.SHA256(data, appSecret);
    }

    public static String toBearerToken(String token) {
        return "Bearer " + token;
    }

    public static boolean validBearerToken(String token, String appSecret) {
        log.info("validBearerToken token: {}, appSecret: {}", (Object)token, (Object)appSecret);
        if (StrUtil.isEmpty((CharSequence)token) || StrUtil.isEmpty((CharSequence)appSecret)) {
            return false;
        }
        if (StrUtil.isEmpty((CharSequence)(token = token.replaceAll("Bearer ", "")))) {
            return false;
        }
        List split = StrUtil.split((CharSequence)token, (CharSequence)".");
        if (CollectionUtil.isEmpty((Collection)split) || split.size() < 3) {
            return false;
        }
        String sign = HMacUtil.SHA256((String)split.get(0) + "." + (String)split.get(1), appSecret);
        return ((String)split.get(2)).equals(sign);
    }
}

