/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.aspect;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import top.cenze.utils.aop.ApiAuth;
import top.cenze.utils.plugins.ApiPlugin;

public abstract class ApiAuthAspect
extends ApiPlugin {
    private static final Logger log = LoggerFactory.getLogger(ApiAuthAspect.class);

    @Pointcut(value="@annotation(top.cenze.utils.aop.ApiAuth)")
    public void authPointcut() {
    }

    @Before(value="authPointcut()")
    public void authBefore(JoinPoint joinPoint) throws Exception {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ApiAuth apiAuth = method.getAnnotation(ApiAuth.class);
        if (ObjectUtil.isNull((Object)apiAuth)) {
            return;
        }
        log.info("authBefore apiAuth: {}", (Object)JSON.toJSONString((Object)apiAuth));
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = requestAttributes.getRequest();
        if (apiAuth.chkAuth() && !this.auth(request, true)) {
            throw new Exception("\u672a\u9274\u6743\u7684\u8bbf\u95ee");
        }
        if (apiAuth.chkLimit() && this.exceedLimitCount(request)) {
            throw new Exception("\u8d85\u8fc7\u8bf7\u6c42\u6b21\u6570\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }
}

