/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationFilter;

public class AspectUtil {
    private static final Logger log = LoggerFactory.getLogger(AspectUtil.class);
    private static final String IP_UTILS_FLAG = ",";
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static Map<String, Object> getRequestAllParams(JoinPoint point) {
        Map<String, Object> params = AspectUtil.getRequestParams(point);
        log.info("getRequestAllParams params: {}", (Object)JSON.toJSONString(params));
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(allParams)) {
            for (Map.Entry entry : allParams.entrySet()) {
                String name = (String)entry.getKey();
                log.info("getRequestAllParams name: {}", (Object)name);
                Object obj = entry.getValue();
                log.info("getRequestAllParams obj: {}", (Object)JSON.toJSONString(obj));
                if (AspectUtil.isJavaLang(obj)) {
                    params.put(name, obj);
                    continue;
                }
                Map<String, Object> paramsByObj = AspectUtil.getParamsByObj(obj);
                log.info("getRequestAllParams paramsByObj: {}", (Object)JSON.toJSONString(paramsByObj));
                if (!CollectionUtil.isNotEmpty(paramsByObj)) continue;
                allParams.putAll(paramsByObj);
            }
        }
        return allParams;
    }

    public static Map<String, Object> getRequestParams(JoinPoint point) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)point.getSignature();
        log.info("getRequestParams signature: {}", (Object)JSON.toJSONString((Object)signature));
        Object[] args = point.getArgs();
        log.info("getRequestParams args: {}", (Object)JSON.toJSONString((Object)args));
        String[] paramNames = signature.getParameterNames();
        log.info("getRequestParams paramNames: {}", (Object)JSON.toJSONString((Object)paramNames));
        if (ObjectUtil.isNotEmpty((Object)args) && ObjectUtil.isNotEmpty((Object)paramNames)) {
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (!(obj instanceof HttpServletRequest)) continue;
                String name = paramNames[i];
                params.put(name, obj);
            }
        }
        return params;
    }

    public static Object getParamByName(JoinPoint point, String name) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        log.info("getParamByName signature: {}", (Object)JSON.toJSONString((Object)signature));
        Object[] args = point.getArgs();
        log.info("getParamByName args: {}", (Object)JSON.toJSONString((Object)args));
        if (ObjectUtil.isNotEmpty((Object)args)) {
            for (Object obj : args) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
                log.info("getParamByName jsonObject: {}", (Object)JSON.toJSONString((Object)jsonObject));
                if (!jsonObject.containsKey((Object)name)) continue;
                return jsonObject.get((Object)name);
            }
        }
        return null;
    }

    public static Map<String, Object> getResponseAllParams(JoinPoint point) {
        Map<String, Object> params = AspectUtil.getResponseParams(point);
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(allParams)) {
            for (Map.Entry entry : allParams.entrySet()) {
                String name = (String)entry.getKey();
                Object obj = entry.getValue();
                if (AspectUtil.isJavaLang(obj)) {
                    params.put(name, obj);
                    continue;
                }
                Map<String, Object> paramsByObj = AspectUtil.getParamsByObj(obj);
                if (!CollectionUtil.isNotEmpty(paramsByObj)) continue;
                allParams.putAll(paramsByObj);
            }
        }
        return allParams;
    }

    public static Map<String, Object> getResponseParams(JoinPoint point) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object[] args = point.getArgs();
        String[] paramNames = signature.getParameterNames();
        if (ObjectUtil.isNotEmpty((Object)args) && ObjectUtil.isNotEmpty((Object)paramNames)) {
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (!(obj instanceof HttpServletResponse)) continue;
                String name = paramNames[i];
                params.put(name, obj);
            }
        }
        return params;
    }

    public static Map<String, Object> getParamsByObj(Object obj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        if (ObjectUtil.isNotEmpty((Object)fields)) {
            for (Field field : fields) {
                field.setAccessible(true);
                String key = field.getName();
                try {
                    Object val = field.get(obj);
                    if (!ObjectUtil.isNotEmpty((Object)val)) continue;
                    params.put(key, val);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    public static void setParamByName(JoinPoint point, String name, Object val) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        CharSequence[] names = methodSignature.getParameterNames();
        log.info("setParamByName names: {}", (Object)JSON.toJSONString((Object)names));
        Object[] args = point.getArgs();
        log.info("setParamByName args: {}", (Object)JSON.toJSONString((Object)args));
        if (ObjectUtil.isNull((Object)names) || ObjectUtil.isNull((Object)args) || 0 == names.length || 0 == args.length) {
            return;
        }
        int idx = ArrayUtil.indexOfIgnoreCase((CharSequence[])names, (CharSequence)name);
        log.info("setParamByName idx: {}", (Object)idx);
        if (idx >= 0) {
            if (AspectUtil.isJavaLang(args[idx])) {
                args[idx] = val;
            }
        } else {
            for (Object obj : args) {
                Method setPlatformIdMethod = obj.getClass().getMethod("setPlatformId", Long.class);
                log.info("setParamByName args2: {}", (Object)JSON.toJSONString((Object)args));
                if (ObjectUtil.isNull((Object)setPlatformIdMethod)) continue;
                setPlatformIdMethod.invoke(obj, val);
                log.info("setParamByName args3: {}", (Object)JSON.toJSONString((Object)args));
            }
        }
    }

    public static String getIpAddress(HttpServletRequest request) {
        String ip;
        block13: {
            if (request == null) {
                return UNKNOWN;
            }
            ip = null;
            try {
                ip = request.getHeader("X-Original-Forwarded-For");
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Forwarded-For");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("x-forwarded-for");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Real-IP");
                }
                if (!StrUtil.isEmpty((CharSequence)ip) && !UNKNOWN.equalsIgnoreCase(ip) || !LOCALHOST_IP1.equalsIgnoreCase(ip = request.getRemoteAddr()) && !LOCALHOST_IP.equalsIgnoreCase(ip)) break block13;
                InetAddress iNet = null;
                try {
                    iNet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error("getClientIp error: ", (Throwable)e);
                }
                ip = iNet.getHostAddress();
            }
            catch (Exception e) {
                log.error("IPUtils ERROR ", (Throwable)e);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return ip;
    }

    public static boolean isJavaLang(Object obj) {
        return AnnotationFilter.PLAIN.matches(obj.getClass());
    }
}

