/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.crypt;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;

public class HMacUtil {
    public static String MD5(String data, String secretKey) {
        HMac mac = new HMac(HmacAlgorithm.HmacMD5, secretKey.getBytes());
        return mac.digestBase64(data, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String SHA1(String data, String secretKey) {
        HMac mac = new HMac(HmacAlgorithm.HmacSHA1, secretKey.getBytes());
        return mac.digestBase64(data, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String SHA256(String data, String secretKey) {
        HMac mac = new HMac(HmacAlgorithm.HmacSHA256, secretKey.getBytes());
        return mac.digestBase64(data, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String SHA384(String data, String secretKey) {
        HMac mac = new HMac(HmacAlgorithm.HmacSHA384, secretKey.getBytes());
        return mac.digestBase64(data, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static String SHA512(String data, String secretKey) {
        HMac mac = new HMac(HmacAlgorithm.HmacSHA512, secretKey.getBytes());
        return mac.digestBase64(data, CharsetUtil.CHARSET_UTF_8, true);
    }

    public static boolean verify(String data, String secretKey, String hmacVerify) {
        return HMacUtil.verify(data, secretKey, hmacVerify, HmacAlgorithm.HmacSHA256);
    }

    public static boolean verify(String data, String secretKey, String hmacVerify, HmacAlgorithm hmacAlgorithm) {
        if (ObjectUtil.isNull((Object)hmacAlgorithm)) {
            hmacAlgorithm = HmacAlgorithm.HmacSHA256;
        }
        String hmac = null;
        switch (hmacAlgorithm) {
            case HmacMD5: {
                hmac = HMacUtil.MD5(data, secretKey);
                break;
            }
            case HmacSHA1: {
                hmac = HMacUtil.SHA1(data, secretKey);
                break;
            }
            case HmacSHA256: {
                hmac = HMacUtil.SHA256(data, secretKey);
                break;
            }
            case HmacSHA384: {
                hmac = HMacUtil.SHA384(data, secretKey);
                break;
            }
            case HmacSHA512: {
                hmac = HMacUtil.SHA512(data, secretKey);
            }
        }
        return hmac.equals(hmacVerify);
    }
}

