/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.crypt;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import top.cenze.utils.pojo.RsaKeyPair;

public class RSAUtil {
    public static int KEY_LENGTH = 1024;
    public static String ALGORITHM_TYPE = "RSA";

    public static RsaKeyPair genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ALGORITHM_TYPE);
        SecureRandom secureRandom = new SecureRandom();
        keyPairGenerator.initialize(KEY_LENGTH, secureRandom);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        String privateKeyStr = Base64.getEncoder().encodeToString(privateKey.getEncoded());
        String publicKeyStr = Base64.getEncoder().encodeToString(publicKey.getEncoded());
        RsaKeyPair pair = new RsaKeyPair();
        pair.setPrivateKey(privateKeyStr);
        pair.setPublicKey(publicKeyStr);
        return pair;
    }

    public static String encrypt(String data, String publicKey) throws Exception {
        byte[] publicKeyByte = Base64.getDecoder().decode(publicKey);
        PublicKey pubKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKeyByte));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        String encryptData = Base64.getEncoder().encodeToString(cipher.doFinal(data.getBytes()));
        return encryptData;
    }

    public static String decrypt(String data, String privateKey) throws Exception {
        byte[] privateKeyByte = Base64.getDecoder().decode(privateKey);
        byte[] dataByte = Base64.getDecoder().decode(data.getBytes());
        PrivateKey priKey = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKeyByte));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        String decryptData = new String(cipher.doFinal(dataByte));
        return decryptData;
    }
}

