/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.crypt;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import top.cenze.utils.ConvertUtil;
import top.cenze.utils.crypt.sm.sm2.Cipher;
import top.cenze.utils.crypt.sm.sm2.SM2;

public class SM2Util {
    public static Map generateKeyPair() {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        publicKey.getEncoded(true);
        keyMap.put("privateKey", ConvertUtil.byteToHex(privateKey.toByteArray()));
        keyMap.put("publicKey", ConvertUtil.byteToHex(publicKey.getEncoded(true)));
        return keyMap;
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return ConvertUtil.byteToHex(c1.getEncoded()) + ConvertUtil.byteToHex(source) + ConvertUtil.byteToHex(c3);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = ConvertUtil.byteToHex(encryptedData);
        byte[] c1Bytes = ConvertUtil.hexToByte(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = ConvertUtil.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = ConvertUtil.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    public static String encrypt(String publicKeyStr, String dataStr) throws IOException {
        byte[] publicKey = ConvertUtil.hexToByte(publicKeyStr);
        byte[] data = dataStr.getBytes("UTF-8");
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return ConvertUtil.byteToHex(c1.getEncoded()) + ConvertUtil.byteToHex(source) + ConvertUtil.byteToHex(c3);
    }

    public static byte[] decrypt(String privateKeyStr, String encryptedDataStr) throws IOException {
        byte[] privateKey = ConvertUtil.hexToByte(privateKeyStr);
        byte[] encryptedData = ConvertUtil.hexToByte(encryptedDataStr);
        String data = ConvertUtil.byteToHex(encryptedData);
        byte[] c1Bytes = ConvertUtil.hexToByte(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = ConvertUtil.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = ConvertUtil.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }
}

