/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.crypt;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM4Util {
    private static final String ENCODING = "UTF-8";
    public static final String ALGORIGTHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS7Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORIGTHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static String generateKey() throws Exception {
        return SM4Util.generateKey(128);
    }

    public static String generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORIGTHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return ByteUtils.toHexString((byte[])kg.generateKey().getEncoded());
    }

    public static String encryptEcb(String hexKey, String paramStr, String charset) throws Exception {
        String cipherText = "";
        if (null != paramStr && !"".equals(paramStr)) {
            byte[] keyData = ByteUtils.fromHexString((String)hexKey);
            if ((charset = charset.trim()).length() <= 0) {
                charset = ENCODING;
            }
            byte[] srcData = paramStr.getBytes(charset);
            byte[] cipherArray = SM4Util.encrypt_Ecb_Padding(keyData, srcData);
            cipherText = ByteUtils.toHexString((byte[])cipherArray);
        }
        return cipherText;
    }

    public static byte[] encrypt_Ecb_Padding(byte[] key, byte[] data) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        byte[] bs = cipher.doFinal(data);
        return bs;
    }

    public static String decryptEcb(String hexKey, String cipherText, String charset) throws Exception {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        if ((charset = charset.trim()).length() <= 0) {
            charset = ENCODING;
        }
        decryptStr = new String(srcData, charset);
        return decryptStr;
    }

    public static byte[] decrypt_Ecb_Padding(byte[] key, byte[] cipherText) throws Exception {
        Cipher cipher = SM4Util.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = SM4Util.decrypt_Ecb_Padding(keyData, cipherData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

