/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import top.cenze.utils.enums.ExcelTypeEnum;
import top.cenze.utils.enums.ReportFileTypeEnum;

public class CZFileUtil {
    private static final Logger log = LoggerFactory.getLogger(CZFileUtil.class);
    private static final String TEMPLATE_DIR = "template/";
    private static final String REPORT_DIR = "report/";

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static InputStream readFile(String filePath) {
        log.info("loadFile filePath: {}", (Object)filePath);
        boolean exist = FileUtil.exist((String)filePath);
        log.info("loadFile exist: {}", (Object)exist);
        if (!exist) {
            throw new Exception("file is not exist!");
        }
        return new FileInputStream(filePath);
    }

    public static String getResourcePath() {
        String path = ResourceUtil.getResource((String)"").getPath();
        log.info("getResourcePath path: {}", (Object)path);
        return path;
    }

    public static File mkFileToResource(String directory, String fileName) {
        String filePath;
        if (StrUtil.isEmpty((CharSequence)directory)) {
            directory = TEMPLATE_DIR;
        }
        log.info("mkFileToResource dir: {}, fileName: {}", (Object)directory, (Object)fileName);
        File file = null;
        directory = CZFileUtil.getResourcePath() + directory;
        if (!FileUtil.exist((String)directory)) {
            FileUtil.mkdir((String)directory);
        }
        file = !FileUtil.exist((String)(filePath = directory + fileName)) ? FileUtil.touch((String)filePath) : FileUtil.file((String)filePath);
        return file;
    }

    public static void writeFileToResource(String directory, String fileName, String content) {
        File file = CZFileUtil.mkFileToResource(directory, fileName);
        CZFileUtil.writeFileToResource(file, content);
    }

    public static void writeFileToResource(File file, String content) {
        try {
            FileWriter fw = new FileWriter(file);
            fw.write(content);
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeFileToResource(String directory, String fileName, byte[] content) {
        File file = CZFileUtil.mkFileToResource(directory, fileName);
        CZFileUtil.writeFileToResource(file, content);
    }

    public static void writeFileToResource(File file, byte[] content) {
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            fos.write(content);
            fos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File createExcelTemplateFile() {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ExcelTypeEnum.XLSX.getExtname();
        File tmpFile = CZFileUtil.mkFileToResource(TEMPLATE_DIR, templateFileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efa\u6a21\u677f\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File createXmlTemplateFile() {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".xml";
        File tmpFile = CZFileUtil.mkFileToResource(TEMPLATE_DIR, templateFileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efa\u6a21\u677f\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File createReportFIle(ReportFileTypeEnum fileType) {
        String fileName = UUID.randomUUID().toString().replaceAll("-", "") + fileType.getExtname();
        File tmpFile = CZFileUtil.mkFileToResource(REPORT_DIR, fileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efa\u62a5\u8868\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File createPdfFile() {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".pdf";
        File tmpFile = CZFileUtil.mkFileToResource(REPORT_DIR, templateFileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efaPDF\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File createPngFile() {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".png";
        File tmpFile = CZFileUtil.mkFileToResource(REPORT_DIR, templateFileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efaPNG\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File createHtmlFile() {
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".html";
        File tmpFile = CZFileUtil.mkFileToResource(REPORT_DIR, templateFileName);
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efaHTML\u6587\u4ef6\u5931\u8d25");
        }
        return tmpFile;
    }

    public static File loadFile(MultipartFile multiFile) throws IOException {
        if ("".equals(multiFile) || multiFile.getSize() <= 0L) {
            return null;
        }
        File tmpFile = CZFileUtil.mkFileToResource(REPORT_DIR, multiFile.getOriginalFilename());
        if (!FileUtil.exist((File)tmpFile)) {
            throw new NullPointerException("\u521b\u5efa\u6587\u4ef6\u5931\u8d25");
        }
        FileUtils.copyInputStreamToFile((InputStream)multiFile.getInputStream(), (File)tmpFile);
        return tmpFile;
    }

    public static File loadFile(String filePath) {
        if (StrUtil.isEmpty((CharSequence)filePath)) {
            return null;
        }
        if (!FileUtil.exist((String)filePath)) {
            return null;
        }
        return FileUtil.file((String)filePath);
    }

    public static byte[] file2Bytes(File file) {
        if (ObjectUtil.isNull((Object)file)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        byte[] buf = new byte[bis.available()];
        bis.read(buf);
        bis.close();
        return buf;
    }
}

