/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    private static final Integer ZERO = 0;
    private static final Integer ONE_ZERO_TWO_FOUR = 1024;
    private static final Integer NINE_ZERO_ZERO = 900;
    private static final Integer THREE_TWO_SEVEN_FIVE = 3275;
    private static final Integer TWO_ZERO_FOUR_SEVEN = 2047;
    private static final Double ZERO_EIGHT_FIVE = 0.85;
    private static final Double ZERO_SIX = 0.6;
    private static final Double ZERO_FOUR_FOUR = 0.44;
    private static final Double ZERO_FOUR = 0.4;

    public static byte[] compressPicForScale(byte[] imageBytes, long desFileSize) {
        if (imageBytes == null || imageBytes.length <= ZERO || (long)imageBytes.length < desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = ImageUtil.getAccuracy(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue());
        try {
            while ((long)imageBytes.length > desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
            log.info("\u56fe\u7247\u539f\u5927\u5c0f={}kb | \u538b\u7f29\u540e\u5927\u5c0f={}kb", (Object)(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue()), (Object)(imageBytes.length / ONE_ZERO_TWO_FOUR));
        }
        catch (Exception e) {
            log.error("\u3010\u56fe\u7247\u538b\u7f29\u3011msg=\u56fe\u7247\u538b\u7f29\u5931\u8d25!", (Throwable)e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < (long)NINE_ZERO_ZERO.intValue() ? ZERO_EIGHT_FIVE : (size < (long)TWO_ZERO_FOUR_SEVEN.intValue() ? ZERO_SIX : (size < (long)THREE_TWO_SEVEN_FIVE.intValue() ? ZERO_FOUR_FOUR.doubleValue() : ZERO_FOUR.doubleValue()));
        return accuracy;
    }

    public static boolean isNetImage(String image) {
        if (StringUtils.isBlank((String)image)) {
            return false;
        }
        String str = image.substring(0, 10).toLowerCase();
        return str.contains("http:") || str.contains("https:");
    }

    public static byte[] netImageToByte(String imageUrl) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)imageUrl)) {
            return null;
        }
        try {
            URL url = new URL(imageUrl);
            byte[] b = new byte[10240];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int len = -1;
            while ((len = is.read(b)) != -1) {
                os.write(b, 0, len);
            }
            is.close();
            return os.toByteArray();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String netImage2Base64(String imageUrl) {
        return ImageUtil.netImage2Base64(imageUrl, false);
    }

    public static String netImage2Base64(String imageUrl, boolean head) {
        return ImageUtil.netImage2Base64(imageUrl, head, 0L);
    }

    public static String netImage2Base64(String imageUrl, boolean head, long desFileSize) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)imageUrl)) {
            return null;
        }
        String[] split = imageUrl.split(".");
        String type = "png";
        if (null != split && split.length > 0) {
            type = split[split.length - 1];
        }
        byte[] imageBytes = ImageUtil.netImageToByte(imageUrl);
        if (desFileSize > 0L) {
            imageBytes = ImageUtil.compressPicForScale(imageBytes, desFileSize);
        }
        return ImageUtil.netImage2Base64(imageBytes, type, head);
    }

    private static String netImage2Base64(byte[] imageBytes, String type, boolean head) {
        if (imageBytes == null || imageBytes.length <= ZERO) {
            return null;
        }
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            if (head) {
                return "data:image/" + type + ";base64," + encoder.encode(imageBytes);
            }
            return encoder.encode(imageBytes);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String NetImage2Base64(String imageUrl) {
        return ImageUtil.NetImage2Base64(imageUrl, null, false);
    }

    public static String NetImage2FullBase64(String imageUrl) {
        return ImageUtil.NetImage2Base64(imageUrl, "png", true);
    }

    public static String NetImage2Base64(String imageUrl, String type) {
        return ImageUtil.NetImage2Base64(imageUrl, type, true);
    }

    public static String NetImage2Base64(String imageUrl, String type, boolean head) {
        if (StringUtils.isBlank((String)imageUrl)) {
            return null;
        }
        try {
            URL url = new URL(imageUrl);
            byte[] b = new byte[1024];
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            InputStream is = conn.getInputStream();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int len = -1;
            while ((len = is.read(b)) != -1) {
                os.write(b, 0, len);
            }
            is.close();
            BASE64Encoder encoder = new BASE64Encoder();
            if (head) {
                if (StringUtils.isBlank((String)type)) {
                    type = "png";
                }
                return "data:image/" + type + ";base64," + encoder.encode(os.toByteArray());
            }
            return encoder.encode(os.toByteArray());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String LocalImage2Base64(String imagePath) {
        if (StringUtils.isBlank((String)imagePath)) {
            return null;
        }
        try {
            FileInputStream is = new FileInputStream(imagePath);
            byte[] b = new byte[((InputStream)is).available()];
            ((InputStream)is).read(b);
            ((InputStream)is).close();
            BASE64Encoder encoder = new BASE64Encoder();
            return encoder.encode(b);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

