/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.file;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class MultipartFileUtil {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileUtil.class);

    public static FileItem getFileItem(String filePath) {
        File file = new File(filePath);
        return MultipartFileUtil.getFileItem(file);
    }

    public static FileItem getFileItem(File file) {
        log.info("getFileItem file name: {}", (Object)file.getName());
        if (ObjectUtil.isNull((Object)file) && !FileUtil.exist((File)file)) {
            return null;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory(16, null);
        FileItem item = factory.createItem("textField", "text/plain", true, file.getName());
        int bytesRead = 0;
        byte[] buffer = new byte[8192];
        try {
            FileInputStream fis = new FileInputStream(file);
            OutputStream os = item.getOutputStream();
            while ((bytesRead = fis.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
            os.close();
            fis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static MultipartFile getMultipartFile(String filePath) {
        FileItem fileItem = MultipartFileUtil.getFileItem(filePath);
        if (ObjectUtil.isNull((Object)fileItem)) {
            return null;
        }
        return new CommonsMultipartFile(fileItem);
    }

    public static MultipartFile getMultipartFile(File file) {
        log.info("getMultipartFile file name: {}", (Object)file.getName());
        FileItem fileItem = MultipartFileUtil.getFileItem(file);
        if (ObjectUtil.isNull((Object)fileItem)) {
            return null;
        }
        return new CommonsMultipartFile(fileItem);
    }

    public static MultipartFile getMultipartFile(FileItem fileItem) {
        if (ObjectUtil.isNull((Object)fileItem)) {
            return null;
        }
        return new CommonsMultipartFile(fileItem);
    }

    public static String getMd5(MultipartFile file) {
        if (ObjectUtil.isNull((Object)file)) {
            return null;
        }
        return DigestUtils.md5DigestAsHex((InputStream)file.getInputStream());
    }
}

