/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.file;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import top.cenze.utils.file.CZFileUtil;
import top.cenze.utils.file.MultipartFileUtil;

public class PDFUtil {
    private static final Logger log = LoggerFactory.getLogger(PDFUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPageNum(String src) throws IOException {
        int pages = 0;
        try (PDDocument pdDocument = null;){
            pdDocument = PDFUtil.getPDDocument(src);
            pages = pdDocument.getNumberOfPages();
        }
        return pages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toImg(String src, int page) throws IOException {
        PDDocument pdDocument = null;
        int dpi = 100;
        --page;
        try {
            pdDocument = PDFUtil.getPDDocument(src);
            PDFRenderer renderer = new PDFRenderer(pdDocument);
            int pages = pdDocument.getNumberOfPages();
            log.info("PdfToImg pages: {}", (Object)pages);
            if (page <= pages && page >= 0) {
                BufferedImage image;
                BufferedImage bufferedImage = image = renderer.renderImageWithDPI(page, (float)dpi);
                return bufferedImage;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (pdDocument != null) {
                pdDocument.close();
            }
        }
        return null;
    }

    public static void toImgOutputStream(OutputStream os, String src, int page, String imgType) throws IOException {
        BufferedImage bufferedImage = PDFUtil.toImg(src, page);
        if (null != bufferedImage) {
            ImageIO.write((RenderedImage)bufferedImage, imgType, os);
        }
    }

    private static PDDocument getPDDocument(String src) throws IOException {
        if (StrUtil.isNotEmpty((CharSequence)src)) {
            if ("http".equalsIgnoreCase(src.substring(0, 4))) {
                try {
                    URL url = new URL(src);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    return PDDocument.load((InputStream)connection.getInputStream());
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                File file = new File(src);
                FileInputStream inputStream = new FileInputStream(file);
                return PDDocument.load((InputStream)inputStream);
            }
        }
        return null;
    }

    public static MultipartFile mulFile2One(List<MultipartFile> lstMultiFile) {
        if (CollectionUtil.isEmpty(lstMultiFile)) {
            return null;
        }
        File pdf = CZFileUtil.createPdfFile();
        if (ObjectUtil.isNull((Object)pdf) || !FileUtil.exist((File)pdf)) {
            return null;
        }
        log.info("mulFile2One to new file path: {}", (Object)pdf.getPath());
        PDFMergerUtility mergePdf = new PDFMergerUtility();
        for (MultipartFile file : lstMultiFile) {
            if (ObjectUtil.isNull((Object)file) || "".equals(file) || file.getSize() <= 0L) continue;
            log.info("mulFile2One file name: {}", (Object)file.getOriginalFilename());
            mergePdf.addSource(file.getInputStream());
        }
        mergePdf.setDestinationFileName(pdf.getPath());
        mergePdf.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        pdf = CZFileUtil.loadFile(pdf.getPath());
        if (ObjectUtil.isNull((Object)pdf) || !FileUtil.exist((File)pdf) || pdf.length() <= 0L) {
            return null;
        }
        log.info("mulFile2One return file name: {}, size: {}", (Object)pdf.getName(), (Object)pdf.length());
        MultipartFile multipartFile = MultipartFileUtil.getMultipartFile(pdf);
        FileUtil.del((File)pdf);
        return multipartFile;
    }
}

