/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.file;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.XmlUtil;
import java.io.File;
import java.util.UUID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import top.cenze.utils.file.CZFileUtil;

public class XMLUtil {
    private static final String EXCEL_TEMPLATE_DIR = "template/";

    public static Document createDocument() {
        Document doc = XmlUtil.createXml();
        doc.setXmlStandalone(true);
        doc.setXmlVersion("1.0");
        return doc;
    }

    public static Element createElement(Document doc, String name, String data) {
        Text text = doc.createTextNode(name);
        text.setData(data);
        Element element = doc.createElement(name);
        element.appendChild(text);
        return element;
    }

    public static String toXml(Document doc, Element head, Element param, String charset) {
        Element root = doc.createElement("root");
        root.appendChild(head);
        root.appendChild(param);
        doc.appendChild(root);
        if (StrUtil.isEmpty((CharSequence)charset)) {
            charset = "UTF-8";
        }
        if ("GBK".equals(charset)) {
            return XmlUtil.toStr((Document)doc, (String)"GBK", (boolean)true);
        }
        return XmlUtil.toStr((Document)doc);
    }

    public static Document toXmlDoc(String xmlStr) {
        Document doc = XmlUtil.parseXml((String)xmlStr);
        return doc;
    }

    public static String getElementValue(Document doc, String name) {
        if (null == doc) {
            return null;
        }
        if (StrUtil.isEmpty((CharSequence)name)) {
            return null;
        }
        return doc.getElementsByTagName(name).item(0).getFirstChild().getNodeValue();
    }

    public static String toStr(Document xml) {
        if (ObjectUtil.isNull((Object)xml)) {
            return null;
        }
        return XmlUtil.toStr((Document)xml);
    }

    public static byte[] toBytes(Document xml) {
        String str = XMLUtil.toStr(xml);
        if (StrUtil.isNotEmpty((CharSequence)str)) {
            str.getBytes("UTF-8");
        }
        return null;
    }

    public static File toFile(Document xml) {
        if (ObjectUtil.isNull((Object)xml)) {
            return null;
        }
        String templateFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".xml";
        File tmpFile = CZFileUtil.mkFileToResource(EXCEL_TEMPLATE_DIR, templateFileName);
        XmlUtil.toFile((Document)xml, (String)tmpFile.getPath());
        return tmpFile;
    }
}

