/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.http.request;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GatewayUtil {
    private static final Logger log = LoggerFactory.getLogger(GatewayUtil.class);
    private static final String IP_UTILS_FLAG = ",";
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static String getToken(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String token = request.getHeaders().getFirst("TOKEN");
        if (StrUtil.isEmpty((CharSequence)token)) {
            token = GatewayUtil.getParameter(exchange, "TOKEN");
        }
        return token;
    }

    public static String getParameter(ServerWebExchange exchange, String name) {
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = request.getMethod();
        if (HttpMethod.POST.equals((Object)method) || HttpMethod.PUT.equals((Object)method)) {
            String body = GatewayUtil.resolveBodyFromRequest(request);
            JSONObject json = null;
            json = StrUtil.isNotEmpty((CharSequence)body) ? JSON.parseObject((String)body) : new JSONObject();
            log.info("getParameter json: {}", (Object)json.toJSONString());
            if (ObjectUtil.isNotNull((Object)json) && ObjectUtil.isNotNull((Object)json.get((Object)name))) {
                return Convert.toStr((Object)json.get((Object)name));
            }
        } else if (HttpMethod.GET.equals((Object)method)) {
            return (String)request.getQueryParams().getFirst((Object)name);
        }
        return null;
    }

    public static String setParameters(ServerWebExchange exchange, GatewayFilterChain chain, String name, Object value) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(name, value);
        return GatewayUtil.setParameters(exchange, chain, mapParams);
    }

    public static String setParameters(ServerWebExchange exchange, GatewayFilterChain chain, Map<String, Object> mapParams) {
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = request.getMethod();
        String contentType = request.getHeaders().getFirst("Content-Type");
        if (HttpMethod.POST.equals((Object)method) && ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType) || "application/json".equalsIgnoreCase(contentType))) {
            String strBody = GatewayUtil.resolveBodyFromRequest(request);
            if (StrUtil.isEmpty((CharSequence)strBody)) {
                return null;
            }
            if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                if (CollectionUtil.isNotEmpty(mapParams)) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                        sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
                    }
                    return strBody + sb.toString();
                }
            } else if ("application/json".equalsIgnoreCase(contentType)) {
                JSONObject json = null;
                json = StrUtil.isNotEmpty((CharSequence)strBody) ? JSON.parseObject((String)strBody) : new JSONObject();
                log.info("getParameter json: {}", (Object)json.toJSONString());
                if (CollectionUtil.isNotEmpty(mapParams)) {
                    for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                        json.put(entry.getKey(), entry.getValue());
                    }
                    return json.toJSONString();
                }
            }
        } else if (HttpMethod.GET.equals((Object)method)) {
            URI uri = request.getURI();
            StringBuilder query = new StringBuilder();
            String originalQuery = uri.getRawQuery();
            if (StringUtils.hasText((String)originalQuery)) {
                query.append(originalQuery);
                if (originalQuery.charAt(originalQuery.length() - 1) != '&') {
                    query.append('&');
                }
            }
            if (CollectionUtil.isNotEmpty(mapParams)) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                    query.append("&").append(entry.getKey()).append("=").append(entry.getValue());
                }
                return query.toString();
            }
        }
        return null;
    }

    public static Mono<Void> rewriteRequestParams(ServerWebExchange exchange, GatewayFilterChain chain, String strBody) {
        if (StrUtil.isEmpty((CharSequence)strBody)) {
            return chain.filter(exchange);
        }
        Object request = exchange.getRequest();
        HttpMethod method = request.getMethod();
        String contentType = request.getHeaders().getFirst("Content-Type");
        URI uri = request.getURI();
        if (HttpMethod.POST.equals((Object)method) && ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType) || "application/json".equalsIgnoreCase(contentType))) {
            URI newUri = UriComponentsBuilder.fromUri((URI)uri).build(true).toUri();
            request = exchange.getRequest().mutate().uri(newUri).build();
            DataBuffer dataBuffer = GatewayUtil.stringToDataBuffer(strBody);
            final Flux bodyFlux = Flux.just((Object)dataBuffer);
            final HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map)exchange.getRequest().getHeaders());
            int length = strBody.getBytes().length;
            headers.remove((Object)"Content-Length");
            headers.setContentLength((long)length);
            if (StrUtil.isNotEmpty((CharSequence)contentType)) {
                headers.set("Content-Type", contentType);
            }
            request = new ServerHttpRequestDecorator((ServerHttpRequest)request){

                public HttpHeaders getHeaders() {
                    long contentLength = headers.getContentLength();
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.putAll((Map)super.getHeaders());
                    if (contentLength > 0L) {
                        httpHeaders.setContentLength(contentLength);
                    } else {
                        httpHeaders.set("Transfer-Encoding", "chunked");
                    }
                    return httpHeaders;
                }

                public Flux<DataBuffer> getBody() {
                    return bodyFlux;
                }
            };
            request.mutate().header("Content-Length", new String[]{Integer.toString(strBody.length())});
            return chain.filter(exchange.mutate().request(request).build());
        }
        if (HttpMethod.GET.equals((Object)method)) {
            URI newUri = UriComponentsBuilder.fromUri((URI)uri).replaceQuery(strBody).build(true).toUri();
            request = exchange.getRequest().mutate().uri(newUri).build();
            return chain.filter(exchange.mutate().request(request).build());
        }
        return chain.filter(exchange);
    }

    private static String resolveBodyFromRequest(ServerHttpRequest request) {
        Flux body = request.getBody();
        AtomicReference bodyRef = new AtomicReference();
        body.subscribe(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            bodyRef.set(charBuffer.toString());
        });
        return (String)bodyRef.get();
    }

    private static DataBuffer stringToDataBuffer(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        NettyDataBufferFactory nettyDataBufferFactory = new NettyDataBufferFactory(ByteBufAllocator.DEFAULT);
        NettyDataBuffer buffer = nettyDataBufferFactory.allocateBuffer(bytes.length);
        buffer.write(bytes);
        return buffer;
    }

    public static String getRemoteIP(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        return GatewayUtil.getRemoteIP(request);
    }

    public static String getRemoteIP(ServerHttpRequest request) {
        String ip;
        block12: {
            ip = null;
            try {
                ip = request.getHeaders().getFirst("X-Original-Forwarded-For");
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("X-Forwarded-For");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("x-forwarded-for");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("WL-Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("HTTP_CLIENT_IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("HTTP_X_FORWARDED_FOR");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeaders().getFirst("X-Real-IP");
                }
                if (!StrUtil.isEmpty((CharSequence)ip) && !UNKNOWN.equalsIgnoreCase(ip) || !LOCALHOST_IP1.equalsIgnoreCase(ip = request.getRemoteAddress().getAddress().getHostAddress()) && !LOCALHOST_IP.equalsIgnoreCase(ip)) break block12;
                InetAddress iNet = null;
                try {
                    iNet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error("getClientIp error: ", (Throwable)e);
                }
                ip = iNet.getHostAddress();
            }
            catch (Exception e) {
                log.error("IPUtils ERROR ", (Throwable)e);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return ip;
    }

    public static String getServerName(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        return GatewayUtil.getServerName(request);
    }

    public static String getServerName(ServerHttpRequest request) {
        return request.getURI().getHost();
    }
}

