/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.http.request;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.utils.http.request.TrustAllTrustManager;

public class HttpsUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpsUtil.class);

    public static <T> T post(String url, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, new HashMap<String, Object>(), headers, Method.POST, clazz);
    }

    public static <T> T postMap(String url, Map<String, Object> params, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, params, headers, Method.POST, clazz);
    }

    public static <T> T postMap(String url, Map<String, Object> params, Class<T> clazz) {
        return HttpsUtil.request(url, params, null, Method.POST, clazz);
    }

    public static <T> T postObj(String url, Object obj, Class<T> clazz) {
        return HttpsUtil.request(url, JSON.toJSONString((Object)obj), null, Method.POST, clazz);
    }

    public static <T> T postObj(String url, Object obj, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, JSON.toJSONString((Object)obj), headers, Method.POST, clazz);
    }

    public static <T> T postStr(String url, String str, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, str, headers, Method.POST, clazz);
    }

    public static <T> T get(String url, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, new HashMap<String, Object>(), headers, Method.GET, clazz);
    }

    public static <T> T getMap(String url, Map<String, Object> params, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, params, headers, Method.GET, clazz);
    }

    public static <T> T getObj(String url, Object obj, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, JSON.toJSONString((Object)obj), headers, Method.GET, clazz);
    }

    public static <T> T getStr(String url, String str, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, str, headers, Method.GET, clazz);
    }

    public static <T> T putObj(String url, Object obj, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, JSON.toJSONString((Object)obj), headers, Method.PUT, clazz);
    }

    public static <T> T del(String url, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, "", headers, Method.DELETE, clazz);
    }

    public static <T> T delObj(String url, Object obj, Map<String, String> headers, Class<T> clazz) {
        return HttpsUtil.request(url, JSON.toJSONString((Object)obj), headers, Method.DELETE, clazz);
    }

    public static String getCookie(String url, Map<String, Object> params) {
        HttpRequest httpRequest = HttpUtil.createGet((String)url);
        httpRequest.form(params);
        log.info("getCookie url: {}, req: {}", (Object)url, (Object)JSON.toJSONString(params));
        String result = httpRequest.execute().getCookieStr();
        log.info("getCookie result: {}", (Object)result);
        return result;
    }

    public static HttpResponse get(String url, Map<String, Object> params, Map<String, String> headers) {
        HttpRequest request = HttpRequest.get((String)url);
        if (CollectionUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                request.header(head.getKey(), head.getValue());
            }
        }
        if (CollectionUtil.isNotEmpty(params)) {
            request.form(params);
        }
        return request.execute();
    }

    public static <T> T request(String url, String str, Map<String, String> headers, Method method, Class<T> clazz) {
        if (null == method) {
            method = Method.POST;
        }
        HttpRequest httpRequest = HttpUtil.createRequest((Method)method, (String)url);
        httpRequest.setConnectionTimeout(60000000);
        if (CollectionUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                httpRequest.header(head.getKey(), head.getValue());
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)str)) {
            httpRequest.body(str);
        }
        log.info("request url: {}, req: {}", (Object)url, (Object)str);
        String result = httpRequest.execute().body();
        log.info("request result: {}", (Object)result);
        if (!StringUtils.isBlank((CharSequence)result)) {
            if (null != clazz) {
                try {
                    return (T)JSON.parseObject((String)result, clazz);
                }
                catch (Exception e) {
                    log.error("request err: {}, result: {}", (Object)e.getMessage(), (Object)result);
                }
            } else {
                return (T)result;
            }
        }
        return null;
    }

    public static <T> T request(String url, Map<String, Object> params, Map<String, String> headers, Method method, Class<T> clazz) {
        if (null == method) {
            method = Method.POST;
        }
        HttpRequest httpRequest = HttpUtil.createRequest((Method)method, (String)url);
        if (CollectionUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, String> head : headers.entrySet()) {
                httpRequest.header(head.getKey(), head.getValue());
            }
        }
        if (CollectionUtil.isNotEmpty(params)) {
            httpRequest.form(params);
        }
        log.info("request url: {}, req: {}", (Object)url, (Object)JSON.toJSONString(params));
        String result = httpRequest.execute().body();
        log.info("request result: {}", (Object)result);
        if (StrUtil.isNotEmpty((CharSequence)result)) {
            if (null != clazz) {
                try {
                    return (T)JSON.parseObject((String)result, clazz);
                }
                catch (Exception e) {
                    log.error("request err: {}, result: {}", (Object)e.getMessage(), (Object)result);
                }
            } else {
                return (T)result;
            }
        }
        return null;
    }

    public static String httpsPost(String toURL, String data, String dateType) throws Exception {
        StringBuffer bs = new StringBuffer();
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllTrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        SSLSessionContext sslsc = sc.getServerSessionContext();
        sslsc.setSessionTimeout(0);
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        URL url = new URL(toURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(30000);
        connection.setDoOutput(true);
        if ("JSON".equalsIgnoreCase(dateType)) {
            connection.setRequestProperty("Content-Type", "application/json;chert=UTF-8");
        } else {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
        out.write(data);
        out.flush();
        out.close();
        connection.connect();
        int code = connection.getResponseCode();
        InputStream is = null;
        is = code == 200 ? connection.getInputStream() : connection.getErrorStream();
        BufferedReader buffer = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String l = null;
        while ((l = buffer.readLine()) != null) {
            bs.append(l);
        }
        return String.valueOf(bs);
    }

    public static Map<String, Object> objToMap(Object obj) {
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)obj), HashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static StringBuilder mapToSortStr(Map<String, Object> params) {
        params.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()) || "".equals(entry.getValue()));
        ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
        infoIds.sort((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey()));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry2 : infoIds) {
            sb.append((String)entry2.getKey());
            sb.append("=");
            sb.append(entry2.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb;
    }

    public static LinkedHashMap<String, Object> mapToSortMap(Map<String, Object> params) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        params.entrySet().removeIf(entry -> Objects.isNull(entry.getValue()) || "".equals(entry.getValue()));
        ArrayList<Map.Entry<String, Object>> infoIds = new ArrayList<Map.Entry<String, Object>>(params.entrySet());
        infoIds.sort((o1, o2) -> ((String)o1.getKey()).compareToIgnoreCase((String)o2.getKey()));
        for (Map.Entry entry2 : infoIds) {
            map.put((String)entry2.getKey(), entry2.getValue());
        }
        return map;
    }

    public static String objToMacBuff(Object obj) {
        StringBuilder sb = new StringBuilder();
        Map<String, Object> mapParams = HttpsUtil.objToMap(obj);
        LinkedHashMap<String, Object> map = HttpsUtil.mapToSortMap(mapParams);
        for (Map.Entry<String, Object> e : mapParams.entrySet()) {
            sb.append(" ").append(e.getValue());
        }
        return StrUtil.trim((CharSequence)sb.toString());
    }

    public static String getSign(StringBuilder sb, String key) throws UnsupportedEncodingException {
        String signTemp = sb.append(key).toString();
        String signValue = DigestUtil.sha256Hex((String)signTemp).toUpperCase();
        return signValue;
    }

    public static String getSign(Object obj, String key) throws UnsupportedEncodingException {
        Map<String, Object> params = HttpsUtil.objToMap(obj);
        StringBuilder sb = HttpsUtil.mapToSortStr(params);
        String sign = HttpsUtil.getSign(sb, key);
        return sign;
    }

    public static String getParamsAndSign(Object obj, String key) throws UnsupportedEncodingException {
        Map<String, Object> params = HttpsUtil.objToMap(obj);
        StringBuilder sb = HttpsUtil.mapToSortStr(params);
        String sign = HttpsUtil.getSign(sb, key);
        sb.append("&sign=").append(sign);
        return sb.toString();
    }
}

