/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.http.request;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.ServletInputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ZuulUtil {
    private static final Logger log = LoggerFactory.getLogger(ZuulUtil.class);
    private static final String IP_UTILS_FLAG = ",";
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static String getToken(RequestContext ctx) {
        HttpServletRequest request = ctx.getRequest();
        String token = request.getHeader("TOKEN");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = ZuulUtil.getParameter(ctx, "TOKEN");
        }
        return token;
    }

    public static String getParameter(RequestContext ctx, String name) {
        HttpServletRequest request = ctx.getRequest();
        String method = request.getMethod();
        String contentType = request.getHeader("Content-Type");
        if ("GET".equals(method)) {
            request.setCharacterEncoding("UTF-8");
            request.getParameterMap();
            HashMap requestQueryParams = ctx.getRequestQueryParams();
            if (requestQueryParams == null) {
                requestQueryParams = new HashMap();
            }
            log.info("getParameter requestQueryParams: {}", (Object)JSON.toJSONString(requestQueryParams));
            List lstParam = (List)requestQueryParams.get(name);
            if (CollectionUtil.isNotEmpty((Collection)lstParam)) {
                return (String)lstParam.get(0);
            }
        } else if ("POST".equals(method) || "PUT".equals(method)) {
            if (!"multipart/form-data".equals(contentType)) {
                ServletInputStream in = request.getInputStream();
                String body = StreamUtils.copyToString((InputStream)in, (Charset)Charset.forName("UTF-8"));
                if (StrUtil.isEmpty((CharSequence)body)) {
                    body = "{}";
                }
                log.info("getParameter body: {}", (Object)body);
                try {
                    Object params = JSONObject.parseObject((String)body);
                    if (CollectionUtil.isEmpty((Map)params)) {
                        params = Maps.newHashMap();
                    }
                    return Convert.toStr(params.get(name));
                }
                catch (Exception e) {
                    log.error("getParameter err: {}", (Object)e.getMessage());
                }
            } else {
                CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
                MultipartHttpServletRequest multipartRequest = resolver.resolveMultipart(request);
                return multipartRequest.getParameter(name);
            }
        }
        return null;
    }

    public static void setParameter(RequestContext ctx, String name, Object value) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(name, value);
        ZuulUtil.setParameters(ctx, mapParams);
    }

    public static void setParameters(RequestContext ctx, Map<String, Object> mapParams) {
        block12: {
            HttpServletRequest request = ctx.getRequest();
            String method = request.getMethod();
            if ("GET".equals(method)) {
                request.setCharacterEncoding("UTF-8");
                request.getParameterMap();
                HashMap<String, List<String>> requestQueryParams = ctx.getRequestQueryParams();
                if (requestQueryParams == null) {
                    requestQueryParams = new HashMap<String, List<String>>();
                }
                log.info("setParameter requestQueryParams: {}", (Object)JSON.toJSONString(requestQueryParams));
                if (CollectionUtil.isNotEmpty(mapParams)) {
                    for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                        requestQueryParams.put(entry.getKey(), Arrays.asList(Convert.toStr((Object)entry.getValue())));
                    }
                    log.info("setParameter newQueryParams: {}", (Object)JSON.toJSONString(requestQueryParams));
                    ctx.setRequestQueryParams(requestQueryParams);
                }
                break block12;
            }
            if (!"POST".equals(method) && !"PUT".equals(method)) break block12;
            ServletInputStream in = request.getInputStream();
            String body = StreamUtils.copyToString((InputStream)in, (Charset)Charset.forName("UTF-8"));
            log.info("setParameter body: {}", (Object)body);
            if (StrUtil.isEmpty((CharSequence)body)) {
                body = "{}";
            }
            log.info("setParameter body: {}", (Object)body);
            try {
                Object params = JSONObject.parseObject((String)body);
                if (CollectionUtil.isEmpty((Map)params)) {
                    params = Maps.newHashMap();
                }
                if (CollectionUtil.isNotEmpty(mapParams)) {
                    for (Map.Entry<String, Object> entry : mapParams.entrySet()) {
                        params.put(entry.getKey(), entry.getValue());
                    }
                    String newBody = params.toString();
                    log.info("setParameter newBody: {}", (Object)newBody);
                    final byte[] reqBodyBytes = newBody.getBytes();
                    ctx.setRequest((HttpServletRequest)new HttpServletRequestWrapper(request){

                        public ServletInputStream getInputStream() throws IOException {
                            return new ServletInputStreamWrapper(reqBodyBytes);
                        }

                        public int getContentLength() {
                            return reqBodyBytes.length;
                        }

                        public long getContentLengthLong() {
                            return reqBodyBytes.length;
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("setParameter err: {}", (Object)e.getMessage());
            }
        }
    }

    public static String getRemoteIP(RequestContext ctx) {
        HttpServletRequest request = ctx.getRequest();
        return ZuulUtil.getRemoteIP(request);
    }

    public static String getRemoteIP(HttpServletRequest request) {
        String ip;
        block12: {
            ip = null;
            try {
                ip = request.getHeader("X-Original-Forwarded-For");
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Forwarded-For");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("x-forwarded-for");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (StrUtil.isEmpty((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Real-IP");
                }
                if (!StrUtil.isEmpty((CharSequence)ip) && !UNKNOWN.equalsIgnoreCase(ip) || !LOCALHOST_IP1.equalsIgnoreCase(ip = request.getRemoteAddr()) && !LOCALHOST_IP.equalsIgnoreCase(ip)) break block12;
                InetAddress iNet = null;
                try {
                    iNet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    log.error("getClientIp error: ", (Throwable)e);
                }
                ip = iNet.getHostAddress();
            }
            catch (Exception e) {
                log.error("IPUtils ERROR ", (Throwable)e);
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return ip;
    }

    public static String getServerName(RequestContext ctx) {
        HttpServletRequest request = ctx.getRequest();
        return ZuulUtil.getServerName(request);
    }

    public static String getServerName(HttpServletRequest request) {
        return request.getServerName();
    }
}

