/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.utils.plugins;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.utils.TokenUtil;
import top.cenze.utils.aspect.AspectUtil;
import top.cenze.utils.pojo.ApiAuthConfig;

public abstract class ApiPlugin {
    private static final Logger log = LoggerFactory.getLogger(ApiPlugin.class);
    private static final String API_ACCESS_PREFIX = "API_ACCESS:";

    public String isOpenStrIgnoreCase(String requestUri) {
        Set<String> setkeys = this.getOpenApiUris();
        log.info("isOpenStrIgnoreCase openApis: {}", (Object)JSON.toJSONString(setkeys));
        CharSequence[] keys = null;
        if (CollectionUtil.isEmpty(setkeys)) {
            setkeys = new HashSet<String>();
            setkeys.add("");
            keys = new String[]{""};
        } else {
            keys = Convert.toStrArray(setkeys);
        }
        return StrUtil.getContainsStrIgnoreCase((CharSequence)requestUri, (CharSequence[])keys);
    }

    public boolean isOpenIgnoreCase(String requestUri) {
        String containsStr = this.isOpenStrIgnoreCase(requestUri);
        log.info("isOpenIgnoreCase containsStr: {}", (Object)containsStr);
        return StrUtil.isNotEmpty((CharSequence)containsStr);
    }

    public abstract Set<String> getOpenApiUris();

    public boolean auth(HttpServletRequest request) {
        return this.auth(request, false);
    }

    public boolean auth(HttpServletRequest request, boolean isAop) {
        String openApiUri = this.isOpenStrIgnoreCase(request.getServletPath());
        if (StrUtil.isEmpty((CharSequence)openApiUri)) {
            return !isAop;
        }
        ApiAuthConfig apiAuthConfig = this.getApiAuthConfig(openApiUri);
        log.info("auth apiAuthConfig: {}", (Object)JSON.toJSONString((Object)apiAuthConfig));
        if (ObjectUtil.isNull((Object)apiAuthConfig) || !apiAuthConfig.getRequireAuth().equals(1)) {
            return true;
        }
        String token = TokenUtil.resolveBearerTokenFromRequest(request);
        log.info("auth token: {}", (Object)token);
        String appSecret = this.getAuthSecret(token);
        log.info("auth appSecret: {}", (Object)appSecret);
        return TokenUtil.validBearerToken(token, appSecret);
    }

    public abstract String getAuthSecret(String var1);

    public boolean exceedLimitCount(HttpServletRequest request) {
        String openApiUri = this.isOpenStrIgnoreCase(request.getServletPath());
        if (StrUtil.isEmpty((CharSequence)openApiUri)) {
            return false;
        }
        String key = API_ACCESS_PREFIX + AspectUtil.getIpAddress(request) + "_" + openApiUri;
        log.info("exceedLimitCount key: {}", (Object)key);
        ApiAuthConfig apiAuthConfig = this.getAccessApiAuthConfig(key);
        log.info("exceedLimitCount ip apiAuthConfig: {}", (Object)JSON.toJSONString((Object)apiAuthConfig));
        if (ObjectUtil.isNull((Object)apiAuthConfig)) {
            apiAuthConfig = this.getApiAuthConfig(openApiUri);
            log.info("exceedLimitCount apiAuthConfig: {}", (Object)JSON.toJSONString((Object)apiAuthConfig));
        }
        if (ObjectUtil.isNull((Object)apiAuthConfig)) {
            return false;
        }
        Integer limitCount = apiAuthConfig.getLimitCount();
        log.info("exceedLimitCount limitCount: {}", (Object)limitCount);
        if (ObjectUtil.isNull((Object)limitCount)) {
            limitCount = 0;
        }
        Integer limitTime = apiAuthConfig.getLimitTime();
        log.info("exceedLimitCount limitTime: {}", (Object)limitTime);
        if (ObjectUtil.isNull((Object)limitTime)) {
            limitTime = 0;
        }
        if (ObjectUtil.isNull((Object)limitCount) || ObjectUtil.isNull((Object)limitCount) || limitCount <= 0 || limitTime <= 0) {
            return false;
        }
        Integer curTime = Convert.toInt((Object)(System.currentTimeMillis() / 60000L));
        log.info("exceedLimitCount curTime: {}", (Object)curTime);
        Integer accessCount = apiAuthConfig.getAccessCount();
        log.info("exceedLimitCount accessCount: {}", (Object)accessCount);
        if (ObjectUtil.isNull((Object)accessCount)) {
            accessCount = 0;
        }
        Integer accessTime = apiAuthConfig.getAccessFirstTime();
        log.info("exceedLimitCount accessTime: {}", (Object)accessTime);
        if (ObjectUtil.isNull((Object)accessTime) || accessTime.equals(0)) {
            accessTime = curTime;
            apiAuthConfig.setAccessFirstTime(curTime);
        }
        int pastTime = curTime - accessTime;
        log.info("exceedLimitCount pastTime: {}", (Object)pastTime);
        if (pastTime >= limitTime) {
            apiAuthConfig.setAccessCount(0);
            apiAuthConfig.setAccessFirstTime(0);
            accessCount = 0;
        }
        Integer n = accessCount;
        Integer n2 = accessCount = Integer.valueOf(accessCount + 1);
        apiAuthConfig.setAccessCount(accessCount);
        this.setAccessApiAuthConfig(key, apiAuthConfig);
        return accessCount > limitCount;
    }

    public abstract ApiAuthConfig getApiAuthConfig(String var1);

    public abstract ApiAuthConfig getAccessApiAuthConfig(String var1);

    public abstract void setAccessApiAuthConfig(String var1, ApiAuthConfig var2);
}

