/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ZipUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import top.chitucao.summerframework.trie.Trie;
import top.chitucao.summerframework.trie.codec.MapTrieProtoBuf;
import top.chitucao.summerframework.trie.configuration.Configuration;
import top.chitucao.summerframework.trie.configuration.property.Property;
import top.chitucao.summerframework.trie.configuration.property.SimpleProperty;
import top.chitucao.summerframework.trie.dict.Dict;
import top.chitucao.summerframework.trie.node.Node;
import top.chitucao.summerframework.trie.nodemanager.DefaultNodeManagerFactory;
import top.chitucao.summerframework.trie.nodemanager.NodeManager;
import top.chitucao.summerframework.trie.query.Aggregation;
import top.chitucao.summerframework.trie.query.Aggregations;
import top.chitucao.summerframework.trie.query.Criteria;
import top.chitucao.summerframework.trie.query.Criterion;
import top.chitucao.summerframework.trie.query.ResultBuilder;

public class MapTrie<T>
implements Trie<T> {
    private final Node root;
    private LongAdder size;
    private final Configuration configuration;
    private final LinkedList<NodeManager<T, ?>> nodeManagers;
    private final Map<String, NodeManager<T, ?>> nodeManagerNameMap;

    public MapTrie(Configuration configuration) {
        this.checkAndResolveConfiguration(configuration);
        this.configuration = configuration;
        DefaultNodeManagerFactory nodeManagerFactory = new DefaultNodeManagerFactory(configuration);
        this.nodeManagers = nodeManagerFactory.createNodeManagers();
        this.nodeManagerNameMap = this.nodeManagers.stream().collect(Collectors.toMap(m -> m.property().name(), Function.identity()));
        this.root = this.headNodeManager().createNewNode();
    }

    @Override
    public int getDepth() {
        return this.tailNodeManager().property().level();
    }

    @Override
    public int getSize() {
        if (this.configuration.isUseFastErase()) {
            return this.doGetSize(this.root, 0, this.getDepth());
        }
        return this.size.intValue();
    }

    @Override
    public void insert(T t) {
        Node cur = this.root;
        for (NodeManager nodeManager : this.nodeManagers) {
            cur = nodeManager.addChildNode(cur, t);
            if (this.configuration.isUseFastErase() || !nodeManager.property().isLeaf()) continue;
            this.size.increment();
        }
    }

    @Override
    public void erase(Criteria criteria) {
        if (Objects.isNull(criteria) || criteria.getCriterionList().isEmpty()) {
            return;
        }
        if (this.configuration.isUseFastErase()) {
            this.fastErase(criteria);
        } else {
            this.normErase(criteria);
        }
    }

    private void normErase(Criteria criteria) {
        this.criteriaCheck(criteria);
        this.sortCriteria(criteria);
        this.dataSearch(criteria).forEach(this::erase);
    }

    private void fastErase(Criteria criteria) {
        Map<String, Criterion> criteriaMap = criteria.getCriterionMap();
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criteria);
        Iterator iterator = this.nodeManagers.iterator();
        Stream<Node> cur = Stream.of(this.root);
        for (int i = 0; i < maxCriteriaLevel; ++i) {
            NodeManager nodeManager = (NodeManager)iterator.next();
            cur = cur.flatMap(e -> nodeManager.search((Node)e, (Criterion)criteriaMap.get(nodeManager.property().name())).values().stream());
        }
        NodeManager lastNodemanager = (NodeManager)iterator.next();
        cur.forEach(e -> lastNodemanager.remove((Node)e, (Criterion)criteriaMap.get(lastNodemanager.property().name())));
    }

    @Override
    public void erase(T t) {
        Node cur = this.root;
        NodeManager<T, ?> nodeManager = this.headNodeManager();
        Stack<Node> parentNodeStack = new Stack<Node>();
        while (Objects.nonNull(nodeManager)) {
            Node childNode = nodeManager.findChildNode(cur, t);
            if (Objects.isNull(childNode)) {
                return;
            }
            nodeManager = nodeManager.next();
            parentNodeStack.push(cur);
            cur = childNode;
        }
        if (Objects.isNull(cur)) {
            return;
        }
        nodeManager = this.tailNodeManager();
        while (Objects.nonNull(nodeManager)) {
            Node parent = (Node)parentNodeStack.pop();
            nodeManager.removeChildNode(parent, t);
            if (parent.getSize() != 0) break;
            nodeManager = nodeManager.prev();
        }
        if (!this.configuration.isUseFastErase()) {
            this.size.decrement();
        }
    }

    @Override
    public boolean contains(Criteria criteria) {
        this.criteriaCheck(criteria);
        this.sortCriteria(criteria);
        if (criteria.getCriterionList().isEmpty()) {
            return this.root.getSize() != 0;
        }
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criteria);
        return !this.levelSearch(criteria, new Aggregations(), maxCriteriaLevel).isEmpty();
    }

    @Override
    public boolean contains(T t) {
        Node cur = this.root;
        for (NodeManager nodeManager : this.nodeManagers) {
            Node childNode = nodeManager.findChildNode(cur, t);
            if (Objects.isNull(childNode)) {
                return false;
            }
            cur = childNode;
        }
        return true;
    }

    @Override
    public List<T> dataSearch(Criteria criteria) {
        if (!this.configuration.isLeafNodeAsDataNode()) {
            throw new IllegalStateException("Leaf node is not a data node, Data search is not supported");
        }
        this.criteriaCheck(criteria);
        return this.tailNodeManager().mappingDictValues(this.levelSearch(criteria, new Aggregations(), this.tailNodeManager().property().level())).collect(Collectors.toList());
    }

    @Override
    public <R> List<R> propertySearch(Criteria criteria, String property) {
        this.criteriaCheck(criteria);
        this.propertyCheck(property);
        return this.nodeManagerNameMap.get(property).mappingDictValues(this.levelSearch(criteria, new Aggregations(), this.nodeManagerNameMap.get(property).property().level())).collect(Collectors.toList());
    }

    private Set<Number> levelSearch(Criteria criteria, Aggregations aggregations, int level) {
        Iterator iterator = this.nodeManagers.iterator();
        Map<String, Criterion> criteriaMap = criteria.getCriterionMap();
        Map<String, Aggregation> aggregationMap = aggregations.getAggregationMap();
        Stream<Node> cur = Stream.of(this.root);
        for (int i = 0; i < level; ++i) {
            NodeManager nodeManager = (NodeManager)iterator.next();
            String propertyName = nodeManager.property().name();
            cur = cur.flatMap(e -> nodeManager.searchAndAgg((Node)e, (Criterion)criteriaMap.get(propertyName), (Aggregation)((Object)((Object)aggregationMap.get(propertyName)))).values().stream());
        }
        NodeManager levelManager = (NodeManager)iterator.next();
        String levelPropertyName = levelManager.property().name();
        Stream<Map> curChildMap = cur.map(node -> levelManager.searchAndAgg((Node)node, (Criterion)criteriaMap.get(levelPropertyName), (Aggregation)((Object)((Object)aggregationMap.get(levelPropertyName))))).filter(e -> !e.isEmpty());
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criteria);
        if (levelManager.property().level() >= maxCriteriaLevel) {
            return curChildMap.flatMap(childMap -> childMap.keySet().stream()).collect(Collectors.toSet());
        }
        HashSet keys = Sets.newHashSet();
        NodeManager next = (NodeManager)iterator.next();
        curChildMap.forEach(map -> map.forEach((k, v) -> {
            if (!keys.contains(k) && this.childrenAnyMatch((Node)v, next, criteriaMap, aggregationMap, maxCriteriaLevel)) {
                keys.add(k);
            }
        }));
        return keys;
    }

    private boolean childrenAnyMatch(Node node, NodeManager<T, ?> nodeManager, Map<String, Criterion> criteriaMap, Map<String, Aggregation> aggregationMap, int maxCriteriaLevel) {
        String propertyName = nodeManager.property().name();
        Criterion criterion = criteriaMap.get(propertyName);
        if (nodeManager.property().level() == maxCriteriaLevel) {
            return nodeManager.contains(node, criterion);
        }
        Stream<Node> cur = Stream.of(node);
        cur = cur.flatMap(e -> nodeManager.searchAndAgg((Node)e, criterion, (Aggregation)((Object)((Object)aggregationMap.get(propertyName)))).values().stream());
        return cur.anyMatch(childNode -> this.childrenAnyMatch((Node)childNode, nodeManager.next(), criteriaMap, aggregationMap, maxCriteriaLevel));
    }

    @Override
    public <E> List<E> listSearch(Criteria criteria, Aggregations aggregations, ResultBuilder<E> resultBuilder) {
        this.resultBuilderCheck(resultBuilder);
        List<List<Number>> dataList = this.multiLevelSearch(criteria, aggregations, resultBuilder.getSetterMap().keySet().toArray(new String[0]));
        if (dataList.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<E> result = new ArrayList<E>();
        List<Pair<NodeManager, BiConsumer>> propertySetterList = this.getPropertySetterList(resultBuilder);
        for (List<Number> fields : dataList) {
            E data = resultBuilder.getSupplier().get();
            for (int i = 0; i < fields.size(); ++i) {
                Pair<NodeManager, BiConsumer> pair = propertySetterList.get(i);
                try {
                    ((BiConsumer)pair.getValue()).accept(data, ((NodeManager)pair.getKey()).property().dict().getDictValue(fields.get(i)));
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Property value set failed. Property name is " + ((NodeManager)pair.getKey()).property().name() + ". Error msg: " + e.getMessage(), e.getCause());
                }
            }
            result.add(data);
        }
        return result;
    }

    @Override
    public Object treeSearch(Criteria criteria, Aggregations aggregations, String ... properties) {
        if (properties == null || properties.length == 0) {
            return Lists.newArrayList();
        }
        if (properties.length == 1) {
            return this.propertySearch(criteria, properties[0]);
        }
        List<List<Number>> dataList = this.multiLevelSearch(criteria, aggregations, properties);
        if (dataList.isEmpty()) {
            return Maps.newHashMap();
        }
        List<NodeManager> propertyNodeManagerList = this.getPropertyNodeManagerList(properties);
        HashMap result = Maps.newHashMap();
        for (List<Number> fields : dataList) {
            HashMap cur = result;
            for (int i = 0; i < fields.size(); ++i) {
                Object dictValue = propertyNodeManagerList.get(i).property().dict().getDictValue(fields.get(i));
                if (i < properties.length) {
                    Map map = cur;
                    if (!map.containsKey(dictValue)) {
                        if (i == properties.length - 1) {
                            map.put(dictValue, Lists.newArrayList());
                        } else {
                            map.put(dictValue, Maps.newHashMap());
                        }
                    }
                    cur = map.get(dictValue);
                    continue;
                }
                List list = (List)((Object)cur);
                list.add(dictValue);
            }
        }
        return result;
    }

    private List<List<Number>> multiLevelSearch(Criteria criteria, Aggregations aggregations, String ... properties) {
        if (properties == null || properties.length == 0) {
            return Lists.newArrayList();
        }
        this.propertiesCheck(properties);
        this.sortProperties(properties);
        if (Objects.isNull(criteria)) {
            criteria = new Criteria();
        }
        this.criteriaCheck(criteria);
        this.sortCriteria(criteria);
        if (Objects.isNull(aggregations)) {
            aggregations = new Aggregations();
        }
        this.aggregationCheck(aggregations);
        int maxCriteriaLevel = this.getMaxCriteriaLevel(criteria);
        int maxPropertyLevel = this.getMaxPropertyLevel(properties);
        ArrayList result = Lists.newArrayList();
        this.dfsSearch(this.root, this.headNodeManager(), criteria.getCriterionMap(), maxCriteriaLevel, Sets.newHashSet((Object[])properties), maxPropertyLevel, aggregations.getAggregationMap(), result, Lists.newArrayList());
        return result;
    }

    private void dfsSearch(Node cur, NodeManager<T, ?> nodeManager, Map<String, Criterion> criteriaMap, int maxCriteriaLevel, Set<String> propertySet, int maxPropertyLevel, Map<String, Aggregation> aggregationMap, List<List<Number>> result, List<Number> path) {
        int level = nodeManager.property().level();
        String propertyName = nodeManager.property().name();
        if (level > maxCriteriaLevel && level > maxPropertyLevel) {
            result.add(path);
            return;
        }
        Criterion criterion = criteriaMap.get(propertyName);
        Aggregation aggregation = aggregationMap.get(propertyName);
        Map<Number, Node> map = nodeManager.searchAndAgg(cur, criterion, aggregation);
        boolean isResultProperty = propertySet.contains(propertyName);
        for (Map.Entry<Number, Node> entry : map.entrySet()) {
            ArrayList newPath = Lists.newArrayList(path);
            if (isResultProperty) {
                newPath.add(entry.getKey());
            }
            if (Objects.isNull(nodeManager.next())) {
                result.add(newPath);
                return;
            }
            this.dfsSearch(entry.getValue(), nodeManager.next(), criteriaMap, maxCriteriaLevel, propertySet, maxPropertyLevel, aggregationMap, result, newPath);
        }
    }

    @Override
    public <R> Set<R> dictValues(String property, Number ... dictKeys) {
        this.propertyCheck(property);
        if (dictKeys == null || dictKeys.length == 0) {
            return this.nodeManagerNameMap.get(property).property().dict().dictValues();
        }
        Map<Number, ?> dictAll = this.nodeManagerNameMap.get(property).property().dict().dictAll();
        return Arrays.stream(dictKeys).map(dictAll::get).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Integer> dictSizes() {
        HashMap result = Maps.newHashMap();
        for (NodeManager nodeManager : this.nodeManagers) {
            result.put(nodeManager.property().name(), nodeManager.property().dict().getSize());
        }
        return result;
    }

    @Override
    public byte[] serialize() {
        MapTrieProtoBuf.Node rootNode = this.buildToProtoBufNode(MapTrieProtoBuf.Node.newBuilder(), this.root, 0, this.getDepth(), MapTrieProtoBuf.Node.newBuilder().build());
        List<MapTrieProtoBuf.Dict> dictList = this.buildToProtoBufDictList();
        MapTrieProtoBuf.Trie trie = MapTrieProtoBuf.Trie.newBuilder().setRoot(rootNode).setSize(Objects.isNull(this.size) ? 0L : this.size.longValue()).addAllDict(dictList).build();
        return trie.toByteArray();
    }

    private MapTrieProtoBuf.Node buildToProtoBufNode(MapTrieProtoBuf.Node.Builder protoBufCur, Node cur, int level, int depth, MapTrieProtoBuf.Node emptyValueNode) {
        if (level == depth) {
            for (Map.Entry<Number, Node> entry : cur.childMap().entrySet()) {
                protoBufCur.putChild(entry.getKey().longValue(), emptyValueNode);
            }
            return protoBufCur.build();
        }
        int nextLevel = level + 1;
        for (Map.Entry<Number, Node> entry : cur.childMap().entrySet()) {
            protoBufCur.putChild(entry.getKey().longValue(), this.buildToProtoBufNode(MapTrieProtoBuf.Node.newBuilder(), entry.getValue(), nextLevel, depth, emptyValueNode));
        }
        return protoBufCur.build();
    }

    private List<MapTrieProtoBuf.Dict> buildToProtoBufDictList() {
        ArrayList<MapTrieProtoBuf.Dict> dictList = new ArrayList<MapTrieProtoBuf.Dict>();
        ObjectMapper objectMapper = new ObjectMapper();
        for (NodeManager nodeManager : this.nodeManagers) {
            Dict dict = nodeManager.property().dict();
            MapTrieProtoBuf.Dict.Builder dictBuilder = MapTrieProtoBuf.Dict.newBuilder();
            if (dict.getSize() == 0) {
                dictBuilder.setKeyClazz(Long.class.getName()).setValClazz(Object.class.getName());
            } else {
                dictBuilder.setKeyClazz(dict.dictAll().keySet().stream().findAny().map(r -> r.getClass().getName()).orElse(null)).setValClazz(dict.dictAll().values().stream().findAny().map(r -> r.getClass().getName()).orElse(null));
            }
            try {
                dictBuilder.setKv(ByteString.copyFrom((byte[])ZipUtil.gzip((String)objectMapper.writeValueAsString(dict.dictAll()), (String)"utf-8")));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
            dictList.add(dictBuilder.build());
        }
        return dictList;
    }

    @Override
    public void deserialize(byte[] bytes) {
        MapTrieProtoBuf.Trie trie;
        try {
            trie = MapTrieProtoBuf.Trie.parseFrom(bytes);
        }
        catch (IORuntimeException | InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
        List<Pair<Function<Number, Number>, Function<String, Map>>> dictMapperList = this.getDictMapperList(trie.getDictList());
        this.buildFromProtoBufNode(this.root, trie.getRoot(), this.headNodeManager(), dictMapperList);
        this.buildFromProtoBufDict(trie.getDictList(), dictMapperList);
    }

    private void buildFromProtoBufDict(List<MapTrieProtoBuf.Dict> dictList, List<Pair<Function<Number, Number>, Function<String, Map>>> dictMapperList) {
        for (NodeManager nodeManager : this.nodeManagers) {
            int level = nodeManager.property().level();
            Dict dict = nodeManager.property().dict();
            Pair<Function<Number, Number>, Function<String, Map>> pair = dictMapperList.get(level);
            Map map = (Map)((Function)dictMapperList.get(level).getValue()).apply(ZipUtil.unGzip((byte[])dictList.get(level).getKv().toByteArray(), (String)"utf-8"));
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                dict.putDictObj((Number)((Function)pair.getKey()).apply((Number)entry.getKey()), entry.getValue());
            }
            if (!(nodeManager.property() instanceof SimpleProperty)) continue;
            SimpleProperty property = (SimpleProperty)nodeManager.property();
            Long curId = dict.dictAll().keySet().stream().map(Number::longValue).max(Comparator.naturalOrder()).orElse(0L);
            property.getDictKeyAdder().setId(curId);
        }
    }

    private void buildFromProtoBufNode(Node cur, MapTrieProtoBuf.Node protoBufCur, NodeManager<T, ?> nodeManager, List<Pair<Function<Number, Number>, Function<String, Map>>> dictMapperList) {
        Function dictKeyMapper = (Function)dictMapperList.get(nodeManager.property().level()).getKey();
        NodeManager<T, ?> nextNodeManager = nodeManager.next();
        if (nextNodeManager == null) {
            cur.setChild(nodeManager.createEmptyValueNode(protoBufCur.getChildMap().keySet().stream().map(dictKeyMapper)).childMap());
            return;
        }
        for (Map.Entry<Long, MapTrieProtoBuf.Node> entry : protoBufCur.getChildMap().entrySet()) {
            cur.addChild((Number)entry.getKey(), nextNodeManager.createNewNode());
            this.buildFromProtoBufNode(cur.getChild(entry.getKey()), entry.getValue(), nextNodeManager, dictMapperList);
        }
    }

    private List<Pair<Function<Number, Number>, Function<String, Map>>> getDictMapperList(List<MapTrieProtoBuf.Dict> protoBufDictList) {
        ArrayList<Pair<Function<Number, Number>, Function<String, Map>>> result = new ArrayList<Pair<Function<Number, Number>, Function<String, Map>>>();
        for (MapTrieProtoBuf.Dict protoBufDict : protoBufDictList) {
            result.add((Pair<Function<Number, Number>, Function<String, Map>>)new Pair(this.getDictKeyMapper(protoBufDict.getKeyClazz()), this.getDictValMapper(protoBufDict.getKeyClazz(), protoBufDict.getValClazz())));
        }
        return result;
    }

    private Function<String, Map> getDictValMapper(String dictKeyClazzName, String dictValClazzName) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JavaType javaType = objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{Class.forName(dictKeyClazzName), Class.forName(dictValClazzName)});
            return e -> {
                try {
                    return (Map)objectMapper.readValue(e, javaType);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            };
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
    }

    private Function<Number, Number> getDictKeyMapper(String dictKeyClazzName) {
        if (Objects.equals(dictKeyClazzName, Byte.class.getName())) {
            return Number::intValue;
        }
        if (Objects.equals(dictKeyClazzName, Short.class.getName())) {
            return Number::shortValue;
        }
        if (Objects.equals(dictKeyClazzName, Integer.class.getName())) {
            return Number::intValue;
        }
        return Number::longValue;
    }

    private int getMaxPropertyLevel(String ... properties) {
        return this.nodeManagerNameMap.get(properties[properties.length - 1]).property().level();
    }

    private int getMaxCriteriaLevel(Criteria criteria) {
        List<Criterion> criterionList = criteria.getCriterionList();
        return criterionList.isEmpty() ? -1 : this.nodeManagerNameMap.get(criterionList.get(criterionList.size() - 1).getProperty()).property().level();
    }

    private void sortCriteria(Criteria criteria) {
        criteria.getCriterionList().sort(Comparator.comparing(e -> this.nodeManagerNameMap.get(e.getProperty()).property().level()));
    }

    private <E> List<Pair<NodeManager, BiConsumer>> getPropertySetterList(ResultBuilder<E> resultBuilder) {
        ArrayList propertySetterList = Lists.newArrayList();
        for (NodeManager nodeManager : this.nodeManagers) {
            String propertyName = nodeManager.property().name();
            if (!resultBuilder.getSetterMap().containsKey(propertyName)) continue;
            propertySetterList.add(new Pair((Object)nodeManager, (Object)resultBuilder.getSetterMap().get(propertyName)));
        }
        return propertySetterList;
    }

    private List<NodeManager> getPropertyNodeManagerList(String ... properties) {
        HashSet propertySet = Sets.newHashSet((Object[])properties);
        ArrayList propertyNodeManagerList = Lists.newArrayList();
        for (NodeManager nodeManager : this.nodeManagers) {
            String propertyName = nodeManager.property().name();
            if (!propertySet.contains(propertyName)) continue;
            propertyNodeManagerList.add(nodeManager);
        }
        return propertyNodeManagerList;
    }

    private void sortProperties(String ... properties) {
        Arrays.sort(properties, Comparator.comparing(p -> this.nodeManagerNameMap.get(p).property().level()));
    }

    private NodeManager<T, ?> headNodeManager() {
        return this.nodeManagers.getFirst();
    }

    private NodeManager<T, ?> tailNodeManager() {
        return this.nodeManagers.getLast();
    }

    private int doGetSize(Node cur, int depth, int maxDepth) {
        if (depth == maxDepth) {
            return cur.getSize();
        }
        int sumSize = 0;
        for (Node child : cur.childMap().values()) {
            sumSize += this.doGetSize(child, depth + 1, maxDepth);
        }
        return sumSize;
    }

    private void checkAndResolveConfiguration(Configuration configuration) {
        if (configuration.getProperties().isEmpty()) {
            throw new IllegalStateException("Properties are empty");
        }
        configuration.setLeafNodeAsDataNode(this.checkNodeAsDataNode(configuration.getLastProperty()));
        if (!configuration.isLeafNodeAsDataNode() && !configuration.isUseFastErase()) {
            throw new IllegalStateException("Leaf node is not data node, Fast erase support only");
        }
        if (!configuration.isUseFastErase()) {
            this.size = new LongAdder();
        }
    }

    private boolean checkNodeAsDataNode(Property property) {
        try {
            Object obj = new Object();
            return obj == property.mappingValue(obj);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void criteriaCheck(Criteria criteria) {
        List<Criterion> criterionList = criteria.getCriterionList();
        if (criterionList.isEmpty()) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (Criterion criterion : criterionList) {
            if (!this.nodeManagerNameMap.containsKey(criterion.getProperty())) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(criterion.getProperty()));
            }
            if (propertySet.add(criterion.getProperty())) continue;
            throw new IllegalArgumentException("Duplicate property: " + criterion.getProperty() + " in criteria");
        }
    }

    private void aggregationCheck(Aggregations aggregations) {
        Map<String, Aggregation> aggregationMap = aggregations.getAggregationMap();
        if (aggregationMap.isEmpty()) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (Map.Entry<String, Aggregation> entry : aggregationMap.entrySet()) {
            if (!this.nodeManagerNameMap.containsKey(entry.getKey())) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(entry.getKey()));
            }
            if (propertySet.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate property: " + (Object)((Object)entry.getValue()) + " in aggregations");
        }
    }

    private <E> void resultBuilderCheck(ResultBuilder<E> resultBuilder) {
        Map<String, BiConsumer> setterMap = resultBuilder.getSetterMap();
        if (setterMap.isEmpty()) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (Map.Entry<String, BiConsumer> entry : setterMap.entrySet()) {
            if (!this.nodeManagerNameMap.containsKey(entry.getKey())) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(entry.getKey()));
            }
            if (propertySet.add(entry.getKey())) continue;
            throw new IllegalArgumentException("Duplicate property: " + entry.getValue() + " in resultBuilder");
        }
    }

    private void propertiesCheck(String ... properties) {
        if (properties == null || properties.length == 0) {
            return;
        }
        HashSet<String> propertySet = new HashSet<String>();
        for (String property : properties) {
            if (!this.nodeManagerNameMap.containsKey(property)) {
                throw new IllegalArgumentException(this.propertyNotDefinedMsg(property));
            }
            if (propertySet.add(property)) continue;
            throw new IllegalArgumentException("Duplicate property: " + property + "in properties");
        }
    }

    private void propertyCheck(String property) {
        if (!this.nodeManagerNameMap.containsKey(property)) {
            throw new IllegalArgumentException(this.propertyNotDefinedMsg(property));
        }
    }

    private String propertyNotDefinedMsg(String property) {
        return "Property: " + property + " is not defined, Properties: " + this.nodeManagerNameMap.keySet();
    }
}

