/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.dict;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import top.chitucao.summerframework.trie.dict.Dict;

public class HashMapDict<R>
implements Dict<R> {
    protected Map<Number, R> dict;
    protected Map<R, Number> indexer;

    public HashMapDict() {
        this.dict = new ConcurrentHashMap<Number, R>();
        this.indexer = new ConcurrentHashMap<R, Number>();
    }

    public HashMapDict(Integer capacity) {
        this.dict = new ConcurrentHashMap<Number, R>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.indexer = new ConcurrentHashMap<R, Number>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
    }

    @Override
    public int getSize() {
        return this.dict.size();
    }

    @Override
    public Set<R> dictValues() {
        return this.indexer.keySet();
    }

    @Override
    public Map<Number, R> dictAll() {
        return this.dict;
    }

    @Override
    public Number getDictKey(R r) {
        return this.indexer.get(r);
    }

    @Override
    public R getDictValue(Number dictKey) {
        return this.dict.get(dictKey);
    }

    @Override
    public void putDict(Number dictKey, R dictValue) {
        this.indexer.put(dictValue, dictKey);
        this.dict.put(dictKey, dictValue);
    }

    @Override
    public void putDictObj(Number dictKey, Object dictValue) {
        Object val = dictValue;
        this.indexer.put(val, dictKey);
        this.dict.put(dictKey, val);
    }

    @Override
    public boolean containsDictKey(Number dictKey) {
        return this.dict.containsKey(dictKey);
    }

    @Override
    public boolean containsDictValue(R r) {
        return this.indexer.containsKey(r);
    }
}

