/*
 * Decompiled with CFR 0.152.
 */
package top.chitucao.summerframework.trie.dict;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import top.chitucao.summerframework.trie.dict.Dict;

public class HashMapDict<R>
implements Dict<R> {
    protected Map<Number, R> dict;
    protected Map<R, Number> indexer;
    protected Map<Number, Integer> counter;
    protected boolean removeDictIfNonCount;

    public HashMapDict() {
        this.dict = new ConcurrentHashMap<Number, R>();
        this.indexer = new ConcurrentHashMap<R, Number>();
        this.counter = new ConcurrentHashMap<Number, Integer>();
        this.removeDictIfNonCount = false;
    }

    public HashMapDict(Integer capacity) {
        this.dict = new ConcurrentHashMap<Number, R>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.indexer = new ConcurrentHashMap<R, Number>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.counter = new ConcurrentHashMap<Number, Integer>((int)((float)capacity.intValue() / 0.75f) + 1, 1.0f);
        this.removeDictIfNonCount = false;
    }

    @Override
    public int getSize() {
        return this.dict.size();
    }

    @Override
    public Set<R> dictValues() {
        return this.indexer.keySet();
    }

    @Override
    public Map<Number, R> dictAll() {
        return this.dict;
    }

    @Override
    public Number getDictKey(R r) {
        return this.indexer.get(r);
    }

    @Override
    public R getDictValue(Number dictKey) {
        return this.dict.get(dictKey);
    }

    @Override
    public void putDict(Number dictKey, R dictValue) {
        this.indexer.put(dictValue, dictKey);
        this.dict.put(dictKey, dictValue);
        this.counter.put(dictKey, this.counter.getOrDefault(dictKey, 0) + 1);
    }

    @Override
    public void putDictObj(Number dictKey, Object dictValue) {
        Object val = dictValue;
        this.indexer.put(val, dictKey);
        this.dict.put(dictKey, val);
        this.counter.put(dictKey, this.counter.getOrDefault(dictKey, 0) + 1);
    }

    @Override
    public boolean containsDictKey(Number dictKey) {
        return this.dict.containsKey(dictKey);
    }

    @Override
    public boolean containsDictValue(R r) {
        return this.indexer.containsKey(r);
    }

    @Override
    public void decrDictCount(Number dictKey, int count) {
        this.counter.put(dictKey, this.counter.get(dictKey) - count);
        if (this.removeDictIfNonCount && Objects.equals(this.counter.get(dictKey), 0)) {
            this.removeDictKey(dictKey);
        }
    }

    @Override
    public void removeDictKey(Number dictKey) {
        this.indexer.remove(this.dict.get(dictKey));
        this.dict.remove(dictKey);
        this.counter.remove(dictKey);
    }

    public void setRemoveDictIfNonCount(boolean removeDictIfNonCount) {
        this.removeDictIfNonCount = removeDictIfNonCount;
    }
}

